/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.row;

import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.result.row.ColumnNumberMapRowHandler;

public class ColumnNumberMapRowHandlerTestCase {
    @Test
    public void testProcessWithColumnNumbers() throws SQLException {
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)resultSet.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)3);
        Mockito.when((Object)resultSet.getObject(1)).thenReturn((Object)"value1");
        Mockito.when((Object)resultSet.getObject(2)).thenReturn((Object)"value2");
        Mockito.when((Object)resultSet.getObject(3)).thenReturn((Object)"value3");
        ColumnNumberMapRowHandler handler = new ColumnNumberMapRowHandler(dbConnection, Charset.defaultCharset());
        Map result = handler.process(resultSet);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)"value1", result.get("1"));
        Assert.assertEquals((Object)"value2", result.get("2"));
        Assert.assertEquals((Object)"value3", result.get("3"));
    }

    @Test
    public void testProcessWithDuplicateColumnLabels() throws SQLException {
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)resultSet.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)2);
        Mockito.when((Object)resultSet.getObject(1)).thenReturn((Object)"value1");
        Mockito.when((Object)resultSet.getObject(2)).thenReturn((Object)"value2");
        ColumnNumberMapRowHandler handler = new ColumnNumberMapRowHandler(dbConnection, Charset.defaultCharset());
        Map result = handler.process(resultSet);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((Object)"value1", result.get("1"));
        Assert.assertEquals((Object)"value2", result.get("2"));
    }

    @Test
    public void testConstructorWithDbConnectionOnly() {
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        ColumnNumberMapRowHandler handler = new ColumnNumberMapRowHandler(dbConnection);
        Assert.assertNotNull((Object)handler);
    }
}

