/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.row;

import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLXML;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.result.row.NonStreamingColumnNumberMapRowHandler;
import org.mule.runtime.api.metadata.TypedValue;

public class NonStreamingColumnNumberMapRowHandlerTestCase {
    @Test
    public void testProcessWithColumnNumbers() throws Exception {
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Mockito.when((Object)resultSet.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)3);
        Mockito.when((Object)resultSet.getObject(1)).thenReturn((Object)"value1");
        Mockito.when((Object)resultSet.getObject(2)).thenReturn((Object)"value2");
        Mockito.when((Object)resultSet.getObject(3)).thenReturn((Object)"value3");
        NonStreamingColumnNumberMapRowHandler handler = new NonStreamingColumnNumberMapRowHandler(dbConnection, StandardCharsets.UTF_8);
        Map result = handler.process(resultSet);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)3L, (long)result.size());
        Assert.assertEquals((Object)"value1", result.get("1"));
        Assert.assertEquals((Object)"value2", result.get("2"));
        Assert.assertEquals((Object)"value3", result.get("3"));
    }

    @Test
    public void testProcessWithSQLXML() throws Exception {
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        SQLXML sqlxml = (SQLXML)Mockito.mock(SQLXML.class);
        String xmlContent = "<root><element>value</element></root>";
        Mockito.when((Object)resultSet.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)metaData.getColumnType(1)).thenReturn((Object)2009);
        Mockito.when((Object)resultSet.getObject(1)).thenReturn((Object)sqlxml);
        Mockito.when((Object)sqlxml.getString()).thenReturn((Object)xmlContent);
        NonStreamingColumnNumberMapRowHandler handler = new NonStreamingColumnNumberMapRowHandler(dbConnection);
        Map result = handler.process(resultSet);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Object value = result.get("1");
        Assert.assertTrue((boolean)(value instanceof TypedValue));
        TypedValue typedValue = (TypedValue)value;
        Assert.assertEquals((Object)xmlContent, (Object)typedValue.getValue());
    }

    @Test
    public void testProcessWithBlob() throws Exception {
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Blob blob = (Blob)Mockito.mock(Blob.class);
        byte[] blobData = "blob content".getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream blobStream = new ByteArrayInputStream(blobData);
        Mockito.when((Object)resultSet.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)metaData.getColumnType(1)).thenReturn((Object)2004);
        Mockito.when((Object)resultSet.getObject(1)).thenReturn((Object)blob);
        Mockito.when((Object)blob.getBinaryStream()).thenReturn((Object)blobStream);
        NonStreamingColumnNumberMapRowHandler handler = new NonStreamingColumnNumberMapRowHandler(dbConnection);
        Map result = handler.process(resultSet);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Object value = result.get("1");
        Assert.assertTrue((boolean)(value instanceof TypedValue));
        TypedValue typedValue = (TypedValue)value;
        Assert.assertTrue((boolean)(typedValue.getValue() instanceof ByteArrayInputStream));
    }

    @Test
    public void testProcessWithClob() throws Exception {
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSetMetaData metaData = (ResultSetMetaData)Mockito.mock(ResultSetMetaData.class);
        Clob clob = (Clob)Mockito.mock(Clob.class);
        String clobContent = "clob content";
        StringReader clobReader = new StringReader(clobContent);
        Mockito.when((Object)resultSet.getMetaData()).thenReturn((Object)metaData);
        Mockito.when((Object)metaData.getColumnCount()).thenReturn((Object)1);
        Mockito.when((Object)metaData.getColumnType(1)).thenReturn((Object)2005);
        Mockito.when((Object)resultSet.getObject(1)).thenReturn((Object)clob);
        Mockito.when((Object)clob.getCharacterStream()).thenReturn((Object)clobReader);
        NonStreamingColumnNumberMapRowHandler handler = new NonStreamingColumnNumberMapRowHandler(dbConnection, StandardCharsets.UTF_8);
        Map result = handler.process(resultSet);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((long)1L, (long)result.size());
        Object value = result.get("1");
        Assert.assertTrue((boolean)(value instanceof TypedValue));
        TypedValue typedValue = (TypedValue)value;
        Assert.assertTrue((boolean)(typedValue.getValue() instanceof ByteArrayInputStream));
    }

    @Test
    public void testConstructorWithDbConnectionOnly() {
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        NonStreamingColumnNumberMapRowHandler handler = new NonStreamingColumnNumberMapRowHandler(dbConnection);
        Assert.assertNotNull((Object)handler);
    }

    @Test
    public void testConstructorWithDbConnectionAndCharset() {
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        NonStreamingColumnNumberMapRowHandler handler = new NonStreamingColumnNumberMapRowHandler(dbConnection, StandardCharsets.UTF_16);
        Assert.assertNotNull((Object)handler);
    }
}

