/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.statement;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.db.commons.internal.result.statement.CloseableMap;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.Closeable;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class CloseableMapTestCase
extends AbstractMuleTestCase {
    private CloseableMap<String, Object> closeableMap;
    private Closeable mockCloseable1;
    private Closeable mockCloseable2;
    private Object mockNonCloseable;

    @Before
    public void setUp() {
        this.closeableMap = new CloseableMap();
        this.mockCloseable1 = (Closeable)Mockito.mock(Closeable.class);
        this.mockCloseable2 = (Closeable)Mockito.mock(Closeable.class);
        this.mockNonCloseable = new Object();
    }

    @Test
    public void testConstructor() {
        MatcherAssert.assertThat(this.closeableMap, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertTrue((boolean)this.closeableMap.isEmpty());
        Assert.assertEquals((long)0L, (long)this.closeableMap.size());
    }

    @Test
    public void testPutAndGet() {
        this.closeableMap.put((Object)"key1", (Object)"value1");
        this.closeableMap.put((Object)"key2", (Object)"value2");
        Assert.assertEquals((Object)"value1", (Object)this.closeableMap.get((Object)"key1"));
        Assert.assertEquals((Object)"value2", (Object)this.closeableMap.get((Object)"key2"));
        Assert.assertEquals((long)2L, (long)this.closeableMap.size());
        Assert.assertFalse((boolean)this.closeableMap.isEmpty());
    }

    @Test
    public void testPutReturnsPreviousValue() {
        this.closeableMap.put((Object)"key1", (Object)"value1");
        Object previousValue = this.closeableMap.put((Object)"key1", (Object)"newValue");
        Assert.assertEquals((Object)"value1", (Object)previousValue);
        Assert.assertEquals((Object)"newValue", (Object)this.closeableMap.get((Object)"key1"));
    }

    @Test
    public void testPutReturnsNullForNewKey() {
        Object previousValue = this.closeableMap.put((Object)"key1", (Object)"value1");
        Assert.assertNull((Object)previousValue);
    }

    @Test
    public void testRemove() {
        this.closeableMap.put((Object)"key1", (Object)"value1");
        this.closeableMap.put((Object)"key2", (Object)"value2");
        Object removedValue = this.closeableMap.remove((Object)"key1");
        Assert.assertEquals((Object)"value1", (Object)removedValue);
        Assert.assertNull((Object)this.closeableMap.get((Object)"key1"));
        Assert.assertEquals((Object)"value2", (Object)this.closeableMap.get((Object)"key2"));
        Assert.assertEquals((long)1L, (long)this.closeableMap.size());
    }

    @Test
    public void testRemoveReturnsNullForNonExistentKey() {
        Object removedValue = this.closeableMap.remove((Object)"nonExistent");
        Assert.assertNull((Object)removedValue);
    }

    @Test
    public void testContainsKey() {
        this.closeableMap.put((Object)"key1", (Object)"value1");
        Assert.assertTrue((boolean)this.closeableMap.containsKey((Object)"key1"));
        Assert.assertFalse((boolean)this.closeableMap.containsKey((Object)"nonExistent"));
    }

    @Test
    public void testContainsValue() {
        this.closeableMap.put((Object)"key1", (Object)"value1");
        Assert.assertTrue((boolean)this.closeableMap.containsValue((Object)"value1"));
        Assert.assertFalse((boolean)this.closeableMap.containsValue((Object)"nonExistent"));
    }

    @Test
    public void testClear() {
        this.closeableMap.put((Object)"key1", (Object)"value1");
        this.closeableMap.put((Object)"key2", (Object)"value2");
        Assert.assertEquals((long)2L, (long)this.closeableMap.size());
        this.closeableMap.clear();
        Assert.assertEquals((long)0L, (long)this.closeableMap.size());
        Assert.assertTrue((boolean)this.closeableMap.isEmpty());
        Assert.assertNull((Object)this.closeableMap.get((Object)"key1"));
        Assert.assertNull((Object)this.closeableMap.get((Object)"key2"));
    }

    @Test
    public void testPutAll() {
        HashMap<String, String> sourceMap = new HashMap<String, String>();
        sourceMap.put("key1", "value1");
        sourceMap.put("key2", "value2");
        this.closeableMap.putAll(sourceMap);
        Assert.assertEquals((long)2L, (long)this.closeableMap.size());
        Assert.assertEquals((Object)"value1", (Object)this.closeableMap.get((Object)"key1"));
        Assert.assertEquals((Object)"value2", (Object)this.closeableMap.get((Object)"key2"));
    }

    @Test
    public void testKeySet() {
        this.closeableMap.put((Object)"key1", (Object)"value1");
        this.closeableMap.put((Object)"key2", (Object)"value2");
        Set keySet = this.closeableMap.keySet();
        Assert.assertEquals((long)2L, (long)keySet.size());
        Assert.assertTrue((boolean)keySet.contains("key1"));
        Assert.assertTrue((boolean)keySet.contains("key2"));
    }

    @Test
    public void testValues() {
        this.closeableMap.put((Object)"key1", (Object)"value1");
        this.closeableMap.put((Object)"key2", (Object)"value2");
        Collection values = this.closeableMap.values();
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertTrue((boolean)values.contains("value1"));
        Assert.assertTrue((boolean)values.contains("value2"));
    }

    @Test
    public void testEntrySet() {
        this.closeableMap.put((Object)"key1", (Object)"value1");
        this.closeableMap.put((Object)"key2", (Object)"value2");
        Set entrySet = this.closeableMap.entrySet();
        Assert.assertEquals((long)2L, (long)entrySet.size());
        boolean foundKey1 = false;
        boolean foundKey2 = false;
        for (Map.Entry entry : entrySet) {
            if ("key1".equals(entry.getKey()) && "value1".equals(entry.getValue())) {
                foundKey1 = true;
            }
            if (!"key2".equals(entry.getKey()) || !"value2".equals(entry.getValue())) continue;
            foundKey2 = true;
        }
        Assert.assertTrue((boolean)foundKey1);
        Assert.assertTrue((boolean)foundKey2);
    }

    @Test
    public void testCloseWithCloseableValues() throws MuleException {
        this.closeableMap.put((Object)"closeable1", (Object)this.mockCloseable1);
        this.closeableMap.put((Object)"closeable2", (Object)this.mockCloseable2);
        this.closeableMap.put((Object)"nonCloseable", this.mockNonCloseable);
        this.closeableMap.close();
        ((Closeable)Mockito.verify((Object)this.mockCloseable1)).close();
        ((Closeable)Mockito.verify((Object)this.mockCloseable2)).close();
    }

    @Test
    public void testCloseWithNoCloseableValues() throws MuleException {
        this.closeableMap.put((Object)"nonCloseable1", this.mockNonCloseable);
        this.closeableMap.put((Object)"nonCloseable2", (Object)"stringValue");
        this.closeableMap.close();
    }

    @Test
    public void testCloseWithEmptyMap() throws MuleException {
        this.closeableMap.close();
    }

    @Test
    public void testCloseWithCloseableThrowingException() throws MuleException {
        this.closeableMap.put((Object)"closeable1", (Object)this.mockCloseable1);
        this.closeableMap.put((Object)"closeable2", (Object)this.mockCloseable2);
        MuleException exception = (MuleException)Mockito.mock(MuleException.class);
        ((Closeable)Mockito.doThrow((Throwable[])new Throwable[]{exception}).when((Object)this.mockCloseable1)).close();
        this.closeableMap.close();
        ((Closeable)Mockito.verify((Object)this.mockCloseable1)).close();
        ((Closeable)Mockito.verify((Object)this.mockCloseable2)).close();
    }

    @Test
    public void testCloseWithMultipleCloseablesThrowingExceptions() throws MuleException {
        this.closeableMap.put((Object)"closeable1", (Object)this.mockCloseable1);
        this.closeableMap.put((Object)"closeable2", (Object)this.mockCloseable2);
        MuleException exception1 = (MuleException)Mockito.mock(MuleException.class);
        MuleException exception2 = (MuleException)Mockito.mock(MuleException.class);
        ((Closeable)Mockito.doThrow((Throwable[])new Throwable[]{exception1}).when((Object)this.mockCloseable1)).close();
        ((Closeable)Mockito.doThrow((Throwable[])new Throwable[]{exception2}).when((Object)this.mockCloseable2)).close();
        this.closeableMap.close();
        ((Closeable)Mockito.verify((Object)this.mockCloseable1)).close();
        ((Closeable)Mockito.verify((Object)this.mockCloseable2)).close();
    }

    @Test
    public void testCloseWithMixedValues() throws MuleException {
        this.closeableMap.put((Object)"closeable1", (Object)this.mockCloseable1);
        this.closeableMap.put((Object)"nonCloseable", this.mockNonCloseable);
        this.closeableMap.put((Object)"closeable2", (Object)this.mockCloseable2);
        this.closeableMap.put((Object)"stringValue", (Object)"test");
        this.closeableMap.close();
        ((Closeable)Mockito.verify((Object)this.mockCloseable1)).close();
        ((Closeable)Mockito.verify((Object)this.mockCloseable2)).close();
    }

    @Test
    public void testSizeAfterOperations() {
        Assert.assertEquals((long)0L, (long)this.closeableMap.size());
        this.closeableMap.put((Object)"key1", (Object)"value1");
        Assert.assertEquals((long)1L, (long)this.closeableMap.size());
        this.closeableMap.put((Object)"key2", (Object)"value2");
        Assert.assertEquals((long)2L, (long)this.closeableMap.size());
        this.closeableMap.remove((Object)"key1");
        Assert.assertEquals((long)1L, (long)this.closeableMap.size());
        this.closeableMap.clear();
        Assert.assertEquals((long)0L, (long)this.closeableMap.size());
    }

    @Test
    public void testIsEmptyAfterOperations() {
        Assert.assertTrue((boolean)this.closeableMap.isEmpty());
        this.closeableMap.put((Object)"key1", (Object)"value1");
        Assert.assertFalse((boolean)this.closeableMap.isEmpty());
        this.closeableMap.remove((Object)"key1");
        Assert.assertTrue((boolean)this.closeableMap.isEmpty());
    }

    @Test
    public void testGetNonExistentKey() {
        Assert.assertNull((Object)this.closeableMap.get((Object)"nonExistent"));
    }

    @Test
    public void testPutAllWithEmptyMap() {
        HashMap emptyMap = new HashMap();
        this.closeableMap.putAll(emptyMap);
        Assert.assertEquals((long)0L, (long)this.closeableMap.size());
        Assert.assertTrue((boolean)this.closeableMap.isEmpty());
    }

    @Test
    public void testKeySetIsEmpty() {
        Set keySet = this.closeableMap.keySet();
        Assert.assertTrue((boolean)keySet.isEmpty());
        Assert.assertEquals((long)0L, (long)keySet.size());
    }

    @Test
    public void testValuesIsEmpty() {
        Collection values = this.closeableMap.values();
        Assert.assertTrue((boolean)values.isEmpty());
        Assert.assertEquals((long)0L, (long)values.size());
    }

    @Test
    public void testEntrySetIsEmpty() {
        Set entrySet = this.closeableMap.entrySet();
        Assert.assertTrue((boolean)entrySet.isEmpty());
        Assert.assertEquals((long)0L, (long)entrySet.size());
    }
}

