/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.resolver.param;

import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.db.commons.api.param.ParameterType;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.domain.param.QueryParam;
import org.mule.db.commons.internal.domain.query.QueryTemplate;
import org.mule.db.commons.internal.domain.type.ArrayResolvedDbType;
import org.mule.db.commons.internal.domain.type.DbType;
import org.mule.db.commons.internal.domain.type.DbTypeManager;
import org.mule.db.commons.internal.domain.type.DynamicDbType;
import org.mule.db.commons.internal.domain.type.ResolvedDbType;
import org.mule.db.commons.internal.domain.type.StructDbType;
import org.mule.db.commons.internal.domain.type.UnknownDbType;
import org.mule.db.commons.internal.domain.type.UnknownDbTypeException;
import org.mule.db.commons.internal.resolver.param.ParamTypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryParamTypeResolver
implements ParamTypeResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryParamTypeResolver.class);
    private static final String UNSPECIFIED_TYPE = "UNSPECIFIED";
    private final DbTypeManager dbTypeManager;

    public QueryParamTypeResolver(DbTypeManager dbTypeManager) {
        this.dbTypeManager = dbTypeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, DbType> getParameterTypes(DbConnection connection, QueryTemplate queryTemplate, List<ParameterType> types) throws SQLException {
        HashMap<Integer, DbType> paramTypes = new HashMap<Integer, DbType>();
        PreparedStatement statement = null;
        try {
            statement = connection.getJdbcConnection().prepareStatement(queryTemplate.getSqlText());
            ParameterMetaData parameterMetaData = statement.getParameterMetaData();
            for (QueryParam queryParam : queryTemplate.getParams()) {
                String parameterTypeName;
                int parameterTypeId = parameterMetaData.getParameterType(queryParam.getIndex());
                Optional<ParameterType> type = types.stream().filter(p -> p.getKey().equals(queryParam.getName())).findAny();
                String string = parameterTypeName = type.isPresent() ? type.get().getDbType().getName() : parameterMetaData.getParameterTypeName(queryParam.getIndex());
                DbType dbType = parameterTypeName == null || UNSPECIFIED_TYPE.equals(parameterTypeName) ? UnknownDbType.getInstance() : (type.isPresent() && !(type.get().getDbType() instanceof DynamicDbType) ? type.get().getDbType() : this.resolveDbType(connection, parameterTypeId, parameterTypeName));
                paramTypes.put(queryParam.getIndex(), dbType);
            }
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    LOGGER.warn("Could not close statement", (Throwable)e);
                }
            }
        }
        return paramTypes;
    }

    private DbType resolveDbType(DbConnection connection, int typeId, String typeName) {
        DbType dbType;
        try {
            dbType = this.dbTypeManager.lookup(connection, typeId, typeName);
        }
        catch (UnknownDbTypeException e) {
            dbType = typeId == 2002 ? new StructDbType(typeId, typeName) : (typeId == 2003 ? new ArrayResolvedDbType(typeId, typeName) : new ResolvedDbType(typeId, typeName));
        }
        return dbType;
    }
}

