/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.row;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Map;
import org.apache.commons.io.input.ReaderInputStream;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.result.row.RowHandler;
import org.mule.db.commons.internal.util.CaseInsensitiveLinkedMap;
import org.mule.db.commons.internal.util.InputStreamWithEOFCallbackWrapper;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.IOUtils;

public abstract class AbstractMapRowHandler
implements RowHandler {
    protected DbConnection dbConnection;
    protected Charset charset;

    public AbstractMapRowHandler(DbConnection dbConnection) {
        this.dbConnection = dbConnection;
        this.charset = Charset.defaultCharset();
    }

    public AbstractMapRowHandler(DbConnection dbConnection, Charset charset) {
        this.dbConnection = dbConnection;
        this.charset = charset;
    }

    @Override
    public Map<String, Object> process(ResultSet resultSet) throws SQLException {
        CaseInsensitiveLinkedMap<String, Object> result = new CaseInsensitiveLinkedMap<String, Object>();
        ResultSetMetaData metaData = resultSet.getMetaData();
        int cols = metaData.getColumnCount();
        for (int i = 1; i <= cols; ++i) {
            String columnKey = this.getColumnKey(metaData, i);
            Object value = resultSet.getObject(i);
            Object cellValue = this.getMuleConsumableValue(value);
            result.put(columnKey, cellValue);
        }
        this.validateResult(result, cols);
        return result;
    }

    protected abstract String getColumnKey(ResultSetMetaData var1, int var2) throws SQLException;

    protected void validateResult(Map<String, Object> result, int columnCount) throws SQLException {
    }

    protected Object getMuleConsumableValue(Object value) throws SQLException {
        Object returnValue = value instanceof SQLXML ? this.handleSqlXmlType((SQLXML)value) : (value instanceof Clob ? this.handleClobType((Clob)value) : (value instanceof Blob ? this.handleBlobType((Blob)value) : (value instanceof Struct ? this.handleStructType((Struct)value) : (value instanceof Array ? this.handleArrayType((Array)value) : value))));
        return returnValue;
    }

    private Object handleArrayType(Array value) throws SQLException {
        Object array = value.getArray();
        if (array.getClass().isArray()) {
            Object[] arrayValue = (Object[])array;
            Object[] newArrayValue = new Object[arrayValue.length];
            for (int i = 0; i < newArrayValue.length; ++i) {
                newArrayValue[i] = this.getMuleConsumableValue(arrayValue[i]);
            }
            return newArrayValue;
        }
        return array;
    }

    private Object[] handleStructType(Struct value) throws SQLException {
        return value.getAttributes();
    }

    protected TypedValue<Object> handleSqlXmlType(SQLXML value) throws SQLException {
        if (this.dbConnection != null && this.dbConnection.supportsContentStreaming()) {
            this.dbConnection.incrementActiveLobStreams();
            InputStreamWithEOFCallbackWrapper inputStreamWrapper = new InputStreamWithEOFCallbackWrapper(value.getBinaryStream(), () -> {
                value.free();
                this.dbConnection.decrementActiveLobStreams();
            });
            return new TypedValue((Object)inputStreamWrapper, DataType.builder().type(InputStream.class).mediaType(MediaType.XML).build());
        }
        String stringValue = value.getString();
        value.free();
        return new TypedValue((Object)stringValue, DataType.builder().type(SQLXML.class).mediaType(MediaType.XML).build());
    }

    protected TypedValue<Object> handleBlobType(Blob value) throws SQLException {
        if (this.dbConnection != null && this.dbConnection.supportsContentStreaming()) {
            this.dbConnection.incrementActiveLobStreams();
            InputStreamWithEOFCallbackWrapper inputStreamWrapper = new InputStreamWithEOFCallbackWrapper(value.getBinaryStream(), () -> {
                value.free();
                this.dbConnection.decrementActiveLobStreams();
            });
            return new TypedValue((Object)inputStreamWrapper, DataType.builder().type(InputStream.class).mediaType(MediaType.BINARY).build());
        }
        byte[] bValue = IOUtils.toByteArray((InputStream)value.getBinaryStream());
        value.free();
        return new TypedValue((Object)new ByteArrayInputStream(bValue), DataType.builder().type(byte[].class).mediaType(MediaType.BINARY).build());
    }

    protected TypedValue<Object> handleClobType(Clob value) throws SQLException {
        ReaderInputStream inputStream = null;
        try {
            inputStream = ((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(value.getCharacterStream())).setCharset(this.charset).get();
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        if (this.dbConnection != null && this.dbConnection.supportsContentStreaming()) {
            this.dbConnection.incrementActiveLobStreams();
            InputStreamWithEOFCallbackWrapper inputStreamWrapper = new InputStreamWithEOFCallbackWrapper((InputStream)inputStream, () -> {
                value.free();
                this.dbConnection.decrementActiveLobStreams();
            });
            return new TypedValue((Object)inputStreamWrapper, DataType.builder().type(InputStream.class).mediaType(MediaType.TEXT).charset(this.charset).build());
        }
        byte[] bValue = IOUtils.toByteArray((InputStream)inputStream);
        value.free();
        return new TypedValue((Object)new ByteArrayInputStream(bValue), DataType.builder().type(byte[].class).mediaType(MediaType.TEXT).charset(this.charset).build());
    }
}

