/*
 * Decompiled with CFR 0.152.
 */
package org.mule.db.commons.internal.result.row;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import org.apache.commons.io.input.ReaderInputStream;
import org.mule.db.commons.internal.domain.connection.DbConnection;
import org.mule.db.commons.internal.result.row.AbstractMapRowHandler;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.util.IOUtils;

public class NonStreamingColumnNumberMapRowHandler
extends AbstractMapRowHandler {
    public NonStreamingColumnNumberMapRowHandler(DbConnection dbConnection) {
        super(dbConnection);
    }

    public NonStreamingColumnNumberMapRowHandler(DbConnection dbConnection, Charset charset) {
        super(dbConnection, charset);
    }

    @Override
    protected String getColumnKey(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        return String.valueOf(columnIndex);
    }

    @Override
    protected TypedValue<Object> handleSqlXmlType(SQLXML value) throws SQLException {
        String stringValue = value.getString();
        value.free();
        return new TypedValue((Object)stringValue, DataType.builder().type(SQLXML.class).mediaType(MediaType.XML).build());
    }

    @Override
    protected TypedValue<Object> handleBlobType(Blob value) throws SQLException {
        byte[] bValue = IOUtils.toByteArray((InputStream)value.getBinaryStream());
        value.free();
        return new TypedValue((Object)new ByteArrayInputStream(bValue), DataType.builder().type(byte[].class).mediaType(MediaType.BINARY).build());
    }

    @Override
    protected TypedValue<Object> handleClobType(Clob value) throws SQLException {
        ReaderInputStream inputStream = null;
        try {
            inputStream = ((ReaderInputStream.Builder)ReaderInputStream.builder().setReader(value.getCharacterStream())).setCharset(this.charset).get();
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        byte[] bValue = IOUtils.toByteArray((InputStream)inputStream);
        value.free();
        return new TypedValue((Object)new ByteArrayInputStream(bValue), DataType.builder().type(byte[].class).mediaType(MediaType.TEXT).charset(this.charset).build());
    }
}

