/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.api.message;

import java.io.Serializable;
import org.mule.jms.commons.api.message.JmsAttributes;
import org.mule.jms.commons.api.message.JmsHeaders;
import org.mule.jms.commons.api.message.JmsMessageProperties;
import org.mule.runtime.api.util.Preconditions;

public class AbstractJmsAttributes
implements Serializable {
    private static final long serialVersionUID = -8148917084189760450L;
    private final JmsMessageProperties properties;
    private final JmsHeaders headers;
    private final String ackId;

    public AbstractJmsAttributes(JmsMessageProperties properties, JmsHeaders headers, String ackId) {
        this.properties = properties;
        this.headers = headers;
        this.ackId = ackId;
    }

    public JmsMessageProperties getProperties() {
        return this.properties;
    }

    public JmsHeaders getHeaders() {
        return this.headers;
    }

    public String getAckId() {
        return this.ackId;
    }

    public static class Builder {
        private JmsMessageProperties properties;
        private JmsHeaders headers;
        private String ackId;

        private Builder() {
        }

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder withProperties(JmsMessageProperties properties) {
            this.properties = properties;
            return this;
        }

        public Builder withHeaders(JmsHeaders headers) {
            this.headers = headers;
            return this;
        }

        public Builder withAckId(String ackId) {
            this.ackId = ackId;
            return this;
        }

        public JmsAttributes build() {
            Preconditions.checkArgument((this.properties != null ? 1 : 0) != 0, (String)"No JmsMessageProperties were provided, but they are required for the JmsAttributes");
            Preconditions.checkArgument((this.headers != null ? 1 : 0) != 0, (String)"No JmsHeaders were provided, but they are required for the JmsAttributes");
            return new JmsAttributes(this.properties, this.headers, this.ackId);
        }
    }
}

