/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.operation;

import javax.jms.Destination;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import org.mule.jms.commons.api.destination.DestinationTypeDescriptor;
import org.mule.jms.commons.api.exception.JmsExtensionException;
import org.mule.jms.commons.api.exception.JmsPublishException;
import org.mule.jms.commons.api.exception.JmsPublisherErrorTypeProvider;
import org.mule.jms.commons.api.exception.JmsSecurityException;
import org.mule.jms.commons.api.message.JmsMessageBuilder;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.publish.JmsMessageProducer;
import org.mule.jms.commons.internal.publish.PublisherParameters;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsPublish {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsPublish.class);
    private JmsSessionManager jmsSessionManager;

    public JmsPublish(JmsSessionManager jmsSessionManager) {
        this.jmsSessionManager = jmsSessionManager;
    }

    @Throws(value={JmsPublisherErrorTypeProvider.class})
    public void publish(@Config JmsConfig config, @Connection JmsTransactionalConnection connection, @Summary(value="The name of the Destination where the Message should be sent") String destination, @Optional(defaultValue="QUEUE") @Summary(value="The type of the Destination") DestinationTypeDescriptor destinationType, @Summary(value="A builder for the message that will be published") @ParameterGroup(name="Message", showInDsl=true) JmsMessageBuilder messageBuilder, @ParameterGroup(name="Publish Configuration") PublisherParameters overrides, OperationTransactionalAction transactionalAction, @ConfigOverride OutboundCorrelationStrategy sendCorrelationId, CorrelationInfo correlationInfo) throws JmsExtensionException {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Begin [publish] on " + JmsCommons.getDestinationType(destinationType) + ": [" + destination + "]");
            }
            JmsSession session = JmsCommons.createJmsSession(connection, InternalAckMode.AUTO, destinationType.isTopic(), this.jmsSessionManager, transactionalAction);
            Message message = messageBuilder.build(connection.getJmsSupport(), sendCorrelationId, correlationInfo, session.get(), config);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Message built, sending message to the %s: [%s] using session [%s]", JmsCommons.getDestinationType(destinationType), destination, session.get()));
            }
            Destination jmsDestination = connection.getJmsSupport().createDestination(session.get(), destination, destinationType.isTopic(), config);
            JmsMessageProducer producer = connection.createProducer(session, jmsDestination, destinationType.isTopic());
            producer.publish(message, overrides);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Finished [publish] to the %s: [%s] using session [%s]", JmsCommons.getDestinationType(destinationType), destination, session.get()));
            }
            JmsCommons.releaseResources(session, this.jmsSessionManager, producer);
        }
        catch (JMSSecurityException e) {
            String msg = String.format("A security error occurred while sending a message to the %s: [%s]: %s", JmsCommons.getDestinationType(destinationType), destination, e.getMessage());
            throw new JmsSecurityException(msg, (Exception)((Object)e));
        }
        catch (Throwable e) {
            String msg = String.format("An error occurred while sending a message to the %s: [%s]: %s", JmsCommons.getDestinationType(destinationType), destination, e.getMessage());
            throw new JmsPublishException(msg, e);
        }
    }
}

