/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.operation;

import javax.inject.Inject;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.api.destination.QueueConsumer;
import org.mule.jms.commons.api.destination.TopicConsumer;
import org.mule.jms.commons.api.exception.JmsConsumeException;
import org.mule.jms.commons.api.exception.JmsExtensionException;
import org.mule.jms.commons.api.exception.JmsPublishConsumeErrorTypeProvider;
import org.mule.jms.commons.api.exception.JmsPublishException;
import org.mule.jms.commons.api.exception.JmsSecurityException;
import org.mule.jms.commons.api.message.JmsAttributes;
import org.mule.jms.commons.api.message.JmsMessageBuilder;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.consume.JmsConsumeParameters;
import org.mule.jms.commons.internal.consume.JmsMessageConsumer;
import org.mule.jms.commons.internal.message.JmsResultFactory;
import org.mule.jms.commons.internal.metadata.JmsOutputResolver;
import org.mule.jms.commons.internal.publish.JmsMessageProducer;
import org.mule.jms.commons.internal.publish.JmsPublishParameters;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsPublishConsume {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsPublishConsume.class);
    private JmsResultFactory resultFactory = new JmsResultFactory();
    @Inject
    private JmsSessionManager sessionManager;

    public JmsPublishConsume(JmsSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @OutputResolver(output=JmsOutputResolver.class)
    @Throws(value={JmsPublishConsumeErrorTypeProvider.class})
    public Result<Object, JmsAttributes> publishConsume(@Config JmsConfig config, @Connection JmsConnection connection, @Placement(order=0) @Summary(value="The name of the Queue destination where the Message should be sent") String destination, @Placement(order=1) @Summary(value="A builder for the message that will be published") @ParameterGroup(name="Message", showInDsl=true) JmsMessageBuilder messageBuilder, @Placement(order=2) @ParameterGroup(name="Publish Configuration", showInDsl=true) JmsPublishParameters publishParameters, @Placement(order=3) @ParameterGroup(name="Consume Configuration", showInDsl=true) JmsConsumeParameters consumeParameters, @ConfigOverride OutboundCorrelationStrategy sendCorrelationId, CorrelationInfo correlationInfo) throws JmsExtensionException {
        String msg;
        JmsMessageProducer producer;
        ConsumerType replyConsumerType;
        Message message;
        JmsSession session;
        InternalAckMode resolvedAckMode = JmsCommons.resolveOverride(JmsCommons.toInternalAckMode(config.getConsumerConfig().getAckMode()), JmsCommons.toInternalAckMode(consumeParameters.getAckMode()));
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Begin [publish] of [publishConsume] to the QUEUE: [" + destination + "]");
            }
            JmsSupport jmsSupport = connection.getJmsSupport();
            session = connection.createSession(resolvedAckMode, false);
            message = messageBuilder.build(jmsSupport, sendCorrelationId, correlationInfo, session.get(), config);
            replyConsumerType = this.setReplyDestination(messageBuilder, session, jmsSupport, message);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Message built, sending message to the QUEUE:  [" + destination + "]");
            }
            Destination jmsDestination = jmsSupport.createDestination(session.get(), destination, false, config);
            producer = connection.createProducer(session, jmsDestination, false);
            producer.publish(message, publishParameters);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Finished [publish] of [publishConsume] to the QUEUE: [%s] using session [%s]", destination, session.get()));
                LOGGER.debug(String.format("Preparing for consuming the response from the %s: [%s].", JmsCommons.getDestinationType(replyConsumerType), destination));
            }
        }
        catch (JMSSecurityException e) {
            String msg2 = String.format("A security error occurred while sending a message to the QUEUE: [%s] : ", destination);
            throw new JmsSecurityException(msg2, (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg3 = String.format("An error occurred while sending a message to the QUEUE: [%s]: ", destination);
            throw new JmsPublishException(msg3, (Throwable)e);
        }
        try {
            Message received;
            JmsMessageConsumer consumer = connection.createConsumer(session, message.getJMSReplyTo(), "", replyConsumerType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Waiting for incoming message of %s [%s].", JmsCommons.getDestinationType(replyConsumerType), this.getReplyDestinationName(message.getJMSReplyTo(), replyConsumerType)));
            }
            if ((received = consumer.consume(consumeParameters.getMaximumWaitUnit().toMillis(consumeParameters.getMaximumWait()))) != null) {
                JmsCommons.evaluateMessageAck(resolvedAckMode, session, received, this.sessionManager, null);
            }
            JmsCommons.releaseResources(session, this.sessionManager, consumer, producer);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating response result");
            }
            if (received == null) {
                LOGGER.debug("Resulting JMS Message was [null], creating an empty result");
                return this.resultFactory.createEmptyResult();
            }
            return this.resultFactory.createResult(received, connection.getJmsSupport().getSpecification(), JmsCommons.resolveOverride(JmsCommons.resolveMessageContentType(received, config.getContentType()), consumeParameters.getInboundContentType()), JmsCommons.resolveOverride(JmsCommons.resolveMessageEncoding(received, config.getEncoding()), consumeParameters.getInboundEncoding()), session.getAckId());
        }
        catch (JMSSecurityException e) {
            msg = String.format("A security error occurred while listening for the reply from the %s: [%s]: %s", JmsCommons.getDestinationType(replyConsumerType), destination, e.getMessage());
            throw new JmsSecurityException(msg, (Exception)((Object)e));
        }
        catch (Exception e) {
            msg = String.format("An error occurred while listening for the reply from the %s: [%s]: %s", JmsCommons.getDestinationType(replyConsumerType), destination, e.getMessage());
            throw new JmsConsumeException(msg, e);
        }
    }

    private ConsumerType setReplyDestination(JmsMessageBuilder messageBuilder, JmsSession session, JmsSupport jmsSupport, Message message) throws JMSException {
        if (message.getJMSReplyTo() != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Using provided destination: [%s]", messageBuilder.getReplyTo().getDestination()));
            }
            return messageBuilder.getReplyTo().getDestinationType().isTopic() ? new TopicConsumer() : new QueueConsumer();
        }
        Destination temporaryDestination = jmsSupport.createTemporaryDestination(session.get());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Using temporary destination: [%s]", ((Queue)temporaryDestination).getQueueName()));
        }
        message.setJMSReplyTo(temporaryDestination);
        return new QueueConsumer();
    }

    private String getReplyDestinationName(Destination destination, ConsumerType replyConsumerType) throws JMSException {
        return replyConsumerType.topic() ? ((Topic)destination).getTopicName() : ((Queue)destination).getQueueName();
    }
}

