/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.api;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.metadata.resolving.AttributesStaticTypeResolver;

public class AttributesOutputResolver
extends AttributesStaticTypeResolver {
    public final MetadataType getStaticMetadata() {
        ObjectTypeBuilder attributesBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        attributesBuilder.id(this.attributesName());
        this.addJmsMessageProperties(attributesBuilder);
        this.addJmsHeaders(attributesBuilder);
        attributesBuilder.addField().required(false).key("ackId").value().stringType();
        return attributesBuilder.build();
    }

    public String attributesName() {
        return "JMS Attributes";
    }

    public void createJmsProperties(ObjectTypeBuilder propertiesBuilder) {
        propertiesBuilder.openWith().anyType();
    }

    private void addJmsHeaders(ObjectTypeBuilder attributesBuilder) {
        ObjectTypeBuilder headersBuilder = attributesBuilder.addField().key("headers").required().value().objectType();
        this.integerField(headersBuilder, "deliveryMode", true);
        this.integerField(headersBuilder, "expiration", true);
        this.integerField(headersBuilder, "priority", true);
        this.stringField(headersBuilder, "messageId", true);
        this.integerField(headersBuilder, "timestamp", true);
        this.stringField(headersBuilder, "correlationId", true);
        this.stringField(headersBuilder, "type", true);
        this.stringField(headersBuilder, "deliveryTime", true);
        headersBuilder.addField().key("redelivered").value().booleanType();
        headersBuilder.addField().key("destination").value(this.createDestinationType());
        headersBuilder.addField().key("replyTo").value(this.createDestinationType());
    }

    private MetadataType createDestinationType() {
        ObjectTypeBuilder objectTypeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        objectTypeBuilder.id("JMS Destination");
        objectTypeBuilder.addField().key("destination").value().stringType();
        objectTypeBuilder.addField().key("destinationType").value().stringType().enumOf(new String[]{"QUEUE", "TOPIC"});
        return objectTypeBuilder.build();
    }

    private void addJmsMessageProperties(ObjectTypeBuilder attributesBuilder) {
        ObjectFieldTypeBuilder objectFieldTypeBuilder = attributesBuilder.addField();
        objectFieldTypeBuilder.key("properties");
        ObjectTypeBuilder propertiesBuilder = objectFieldTypeBuilder.value().objectType().id("JMS Message Properties");
        this.addMapField(propertiesBuilder, "all");
        this.addMapField(propertiesBuilder, "userProperties");
        this.createJmsProperties(propertiesBuilder.addField().key("jmsProperties").required().value().objectType());
        this.addJmsxProperties(propertiesBuilder);
    }

    private void addJmsxProperties(ObjectTypeBuilder propertiesBuilder) {
        ObjectTypeBuilder jmsxPropertiesBuilder = propertiesBuilder.addField().key("jmsxProperties").value().objectType();
        jmsxPropertiesBuilder.id("JMSX Properties");
        this.stringField(jmsxPropertiesBuilder, "jmsxUserID", false);
        this.stringField(jmsxPropertiesBuilder, "jmsxAppID", false);
        this.integerField(jmsxPropertiesBuilder, "jmsxDeliveryCount", false);
        this.stringField(jmsxPropertiesBuilder, "jmsxGroupID", false);
        this.integerField(jmsxPropertiesBuilder, "jmsxGroupSeq", false);
        this.stringField(jmsxPropertiesBuilder, "jmsxProducerTXID", false);
        this.stringField(jmsxPropertiesBuilder, "jmsxConsumerTXID", false);
        this.integerField(jmsxPropertiesBuilder, "jmsxRcvTimestamp", false);
    }

    public void stringField(ObjectTypeBuilder jmsxPropertiesBuilder, String name, boolean required) {
        jmsxPropertiesBuilder.addField().required(required).key(name).value().stringType();
    }

    public void integerField(ObjectTypeBuilder jmsxPropertiesBuilder, String name, boolean required) {
        jmsxPropertiesBuilder.addField().required(required).key(name).value().numberType().integer();
    }

    public void addMapField(ObjectTypeBuilder propertiesBuilder, String fieldName) {
        propertiesBuilder.addField().key(fieldName).required().value().objectType().openWith().anyType();
    }
}

