/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.operation;

import org.apache.commons.lang3.StringUtils;
import org.mule.jms.commons.api.exception.JmsAckErrorTypeProvider;
import org.mule.jms.commons.api.exception.JmsAckException;
import org.mule.jms.commons.api.exception.JmsSessionRecoverErrorTypeProvider;
import org.mule.jms.commons.api.exception.JmsSessionRecoverException;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsAcknowledge {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsAcknowledge.class);
    private JmsSessionManager sessionManager;

    public JmsAcknowledge(JmsSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Throws(value={JmsAckErrorTypeProvider.class})
    public void ack(@Summary(value="The AckId of the Message to ACK") String ackId) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)ackId) ? 1 : 0) != 0, (String)"The AckId can not be null or empty");
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Performing ACK on session: " + ackId);
            }
            this.sessionManager.ack(ackId);
        }
        catch (Exception e) {
            LOGGER.error(String.format("An error occurred while acking a message with ID [%s]: ", ackId), (Throwable)e);
            throw new JmsAckException(String.format("An error occurred while trying to perform an ACK on Session with ID [%s]: ", ackId), e);
        }
    }

    @Throws(value={JmsSessionRecoverErrorTypeProvider.class})
    public void recoverSession(String ackId) {
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)ackId) ? 1 : 0) != 0, (String)"The AckId can not be null or empty");
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Recovering session: " + ackId);
            }
            this.sessionManager.recoverSession(ackId);
        }
        catch (Exception e) {
            LOGGER.error(String.format("An error occurred while recovering the session with ID [%s]: ", ackId), (Throwable)e);
            throw new JmsSessionRecoverException(String.format("An error occurred while trying to perform an recover on Session with ID [%s]: ", ackId), e);
        }
    }
}

