/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.operation;

import java.util.concurrent.TimeUnit;
import javax.jms.Destination;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import org.mule.jms.commons.api.config.JmsConsumerConfig;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.api.exception.JmsConsumeErrorTypeProvider;
import org.mule.jms.commons.api.exception.JmsConsumeException;
import org.mule.jms.commons.api.exception.JmsExtensionException;
import org.mule.jms.commons.api.exception.JmsSecurityException;
import org.mule.jms.commons.api.message.JmsAttributes;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.consume.JmsMessageConsumer;
import org.mule.jms.commons.internal.message.JmsResultFactory;
import org.mule.jms.commons.internal.metadata.JmsOutputResolver;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConsume {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsConsume.class);
    private final JmsResultFactory resultFactory = new JmsResultFactory();
    private JmsSessionManager sessionManager;

    public JmsConsume(JmsSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @OutputResolver(output=JmsOutputResolver.class)
    @Throws(value={JmsConsumeErrorTypeProvider.class})
    public Result<Object, JmsAttributes> consume(@Config JmsConfig config, @Connection JmsTransactionalConnection connection, @Summary(value="The name of the Destination from where the Message should be consumed") String destination, @ConfigOverride @Summary(value="The Type of the Consumer that should be used for the provided destination") ConsumerType consumerType, @Optional @Summary(value="The Session ACK mode to use when consuming a message") JmsAckMode ackMode, @ConfigOverride @Summary(value="The JMS selector to be used for filtering incoming messages") String selector, @Optional @Summary(value="The content type of the message body") @Example(value="application/json") String contentType, @Optional @Summary(value="The encoding of the message body") @Example(value="UTF-8") String encoding, @Optional(defaultValue="10000") @Summary(value="Maximum time to wait for a message to arrive before timeout") Long maximumWait, @Optional(defaultValue="MILLISECONDS") @Example(value="MILLISECONDS") @Summary(value="Time unit to be used in the maximumWaitTime configuration") TimeUnit maximumWaitUnit, OperationTransactionalAction transactionalAction) throws JmsExtensionException {
        InternalAckMode resolvedAckMode = this.resolveAck((JmsConsumerConfig)config.getConsumerConfig(), ackMode);
        try {
            Message received;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Begin [consume] on the " + JmsCommons.getDestinationType(consumerType) + ": [" + destination + "]");
            }
            JmsSupport jmsSupport = connection.getJmsSupport();
            JmsSession session = JmsCommons.createJmsSession(connection, resolvedAckMode, consumerType.topic(), this.sessionManager, transactionalAction);
            Destination jmsDestination = jmsSupport.createDestination(session.get(), destination, consumerType.topic(), config);
            JmsMessageConsumer consumer = connection.createConsumer(session, jmsDestination, selector, consumerType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Consuming Message from the " + JmsCommons.getDestinationType(consumerType) + ": [" + destination + "]");
            }
            if ((received = consumer.consume(maximumWaitUnit.toMillis(maximumWait))) == null) {
                LOGGER.debug("Resulting JMS Message was [null], creating an empty result");
                JmsCommons.releaseResources(session, this.sessionManager, consumer);
                return this.resultFactory.createEmptyResult();
            }
            String resolvedContentType = JmsCommons.resolveOverride(JmsCommons.resolveMessageContentType(received, config.getContentType()), contentType);
            String resolvedEncoding = JmsCommons.resolveOverride(JmsCommons.resolveMessageEncoding(received, config.getEncoding()), encoding);
            Result result = this.resultFactory.createResult(received, jmsSupport.getSpecification(), resolvedContentType, resolvedEncoding, session.getAckId());
            JmsCommons.evaluateMessageAck(resolvedAckMode, session, received, this.sessionManager, null);
            JmsCommons.releaseResources(session, this.sessionManager, consumer);
            return result;
        }
        catch (JMSSecurityException e) {
            String msg = String.format("A security error occurred while consuming a message from the %s: [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
            throw new JmsSecurityException(msg, (Exception)((Object)e));
        }
        catch (Exception e) {
            String msg = String.format("An error occurred while consuming a message from the %s [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
            throw new JmsConsumeException(msg, e);
        }
    }

    private InternalAckMode resolveAck(JmsConsumerConfig config, JmsAckMode ackMode) {
        InternalAckMode fallbackAck = JmsCommons.toInternalAckMode(config.getAckMode());
        if (InternalAckMode.AUTO.equals((Object)fallbackAck) || InternalAckMode.DUPS_OK.equals((Object)fallbackAck)) {
            fallbackAck = InternalAckMode.IMMEDIATE;
        }
        return JmsCommons.resolveOverride(fallbackAck, JmsCommons.toInternalAckMode(ackMode));
    }
}

