/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.source;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.mule.jms.commons.api.message.JmsAttributes;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.message.JmsResultFactory;
import org.mule.jms.commons.internal.source.JmsListener;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsMessageListener<T extends JmsAttributes>
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageListener.class);
    private final JmsSession session;
    private final SourceCallback<Object, T> sourceCallback;
    private final JmsListenerLock jmsLock;
    private final InternalAckMode ackMode;
    private final String encoding;
    private final String contentType;
    private final JmsConfig config;
    private final JmsSessionManager sessionManager;
    private final JmsSupport jmsSupport;
    private ConnectionProvider<JmsTransactionalConnection> connectionProvider;
    private final JmsResultFactory resultFactory = new JmsResultFactory();

    JmsMessageListener(JmsSession session, JmsConfig config, JmsListenerLock jmsLock, JmsSessionManager sessionManager, SourceCallback<Object, T> sourceCallback, JmsSupport jmsSupport, InternalAckMode ackMode, String encoding, String contentType, ConnectionProvider<JmsTransactionalConnection> connectionProvider) {
        this.session = session;
        this.sourceCallback = sourceCallback;
        this.jmsLock = jmsLock;
        this.ackMode = ackMode;
        this.encoding = encoding;
        this.contentType = contentType;
        this.config = config;
        this.sessionManager = sessionManager;
        this.jmsSupport = jmsSupport;
        this.connectionProvider = connectionProvider;
    }

    public void onMessage(Message message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received message on session: " + this.session.get().toString());
        }
        SourceCallbackContext context = this.sourceCallback.createContext();
        try {
            context.bindConnection(this.connectionProvider.connect());
        }
        catch (ConnectionException | TransactionException e) {
            JmsListener.notifyIfConnectionProblem(this.sourceCallback, (Exception)e);
        }
        if (this.ackMode.equals((Object)InternalAckMode.TRANSACTED)) {
            this.sessionManager.bindToTransaction(this.session);
        }
        this.saveReplyToDestination(message, context);
        context.addVariable("JMS_LOCK", (Object)this.jmsLock);
        context.addVariable("JMS_SESSION", (Object)this.session);
        context.setCorrelationId(this.getCorrelationId(message));
        this.dispatchMessage(message, context, this.resolveEncoding(message), this.resolveContentType(message));
        this.waitForMessageToBeProcessed(this.jmsLock);
    }

    private String getCorrelationId(Message message) {
        try {
            return message.getJMSCorrelationID();
        }
        catch (JMSException e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to obtain correlationId from message", (Throwable)e);
            }
            return null;
        }
    }

    private String resolveContentType(Message message) {
        return JmsCommons.resolveOverride(JmsCommons.resolveMessageContentType(message, this.config.getContentType()), this.contentType);
    }

    private String resolveEncoding(Message message) {
        return JmsCommons.resolveOverride(JmsCommons.resolveMessageEncoding(message, this.config.getEncoding()), this.encoding);
    }

    private void saveReplyToDestination(Message message, SourceCallbackContext context) {
        try {
            Destination replyTo = message.getJMSReplyTo();
            if (replyTo != null) {
                context.addVariable("REPLY_TO_DESTINATION", (Object)replyTo);
            }
        }
        catch (JMSException e) {
            LOGGER.error("An error occurred while obtaining the ReplyTo destination: ", (Throwable)e);
            JmsListener.notifyIfConnectionProblem(this.sourceCallback, (Exception)((Object)e));
        }
    }

    private void dispatchMessage(Message message, SourceCallbackContext context, String encoding, String contentType) {
        try {
            Result result = this.resultFactory.createResult(message, this.jmsSupport.getSpecification(), contentType, encoding, this.session.getAckId());
            this.registerAckIdIfRequired(message);
            this.sourceCallback.handle(result, context);
            this.doAckIfRequired(message);
        }
        catch (Exception e) {
            String msg = String.format("An error occurred while dispatching a Message from the listener on session [%s]: %s", this.session.get(), e.getMessage());
            LOGGER.error(msg, (Throwable)e);
            JmsListener.notifyIfConnectionProblem(this.sourceCallback, e);
        }
    }

    private void registerAckIdIfRequired(Message message) {
        if (this.ackMode.equals((Object)InternalAckMode.MANUAL)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Registering pending ACK on session: " + this.session.getAckId());
            }
            String id = this.session.getAckId().orElseThrow(() -> new IllegalArgumentException("An AckId is required when MANUAL AckMode is set"));
            this.sessionManager.registerMessageForAck(id, message, this.session.get(), this.jmsLock);
        }
    }

    private void doAckIfRequired(Message message) throws JMSException {
        if (this.ackMode.equals((Object)InternalAckMode.IMMEDIATE)) {
            LOGGER.debug("Automatically performing an ACK over the message, since AckMode was IMMEDIATE");
            message.acknowledge();
        }
    }

    private void waitForMessageToBeProcessed(JmsListenerLock jmsLock) {
        jmsLock.lock();
    }
}

