/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.api.message;

import org.mule.jms.commons.api.destination.JmsDestination;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;

public class JmsHeaders {
    @Parameter
    private JmsDestination destination;
    @Parameter
    private int deliveryMode;
    @Parameter
    private long expiration;
    @Parameter
    private int priority;
    @Parameter
    @Optional
    private String messageId;
    @Parameter
    private long timestamp;
    @Parameter
    @Optional
    private String correlationId;
    @Parameter
    @Optional
    private JmsDestination replyTo;
    @Parameter
    private String type;
    @Parameter
    private boolean redelivered;
    @Parameter
    @Optional
    private Long deliveryTime;

    public String getJMSMessageID() {
        return this.messageId;
    }

    public long getJMSTimestamp() {
        return this.timestamp;
    }

    public String getJMSCorrelationID() {
        return this.correlationId;
    }

    public JmsDestination getJMSReplyTo() {
        return this.replyTo;
    }

    public JmsDestination getJMSDestination() {
        return this.destination;
    }

    public int getJMSDeliveryMode() {
        return this.deliveryMode;
    }

    public boolean getJMSRedelivered() {
        return this.redelivered;
    }

    public String getJMSType() {
        return this.type;
    }

    public long getJMSExpiration() {
        return this.expiration;
    }

    public Long getJMSDeliveryTime() {
        return this.deliveryTime;
    }

    public int getJMSPriority() {
        return this.priority;
    }

    public static class Builder {
        private JmsHeaders jmsHeaders = new JmsHeaders();

        public Builder setMessageId(String messageId) {
            this.jmsHeaders.messageId = messageId;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.jmsHeaders.timestamp = timestamp;
            return this;
        }

        public Builder setCorrelationId(String correlationId) {
            this.jmsHeaders.correlationId = correlationId;
            return this;
        }

        public Builder setReplyTo(JmsDestination replyTo) {
            this.jmsHeaders.replyTo = replyTo;
            return this;
        }

        public Builder setDestination(JmsDestination destination) {
            this.jmsHeaders.destination = destination;
            return this;
        }

        public Builder setDeliveryMode(int deliveryMode) {
            this.jmsHeaders.deliveryMode = deliveryMode;
            return this;
        }

        public Builder setRedelivered(boolean redelivered) {
            this.jmsHeaders.redelivered = redelivered;
            return this;
        }

        public Builder setType(String type) {
            this.jmsHeaders.type = type;
            return this;
        }

        public Builder setExpiration(long expiration) {
            this.jmsHeaders.expiration = expiration;
            return this;
        }

        public Builder setPriority(int priority) {
            this.jmsHeaders.priority = priority;
            return this;
        }

        public Builder setDeliveryTime(long deliveryTime) {
            this.jmsHeaders.deliveryTime = deliveryTime;
            return this;
        }

        public JmsHeaders build() {
            return this.jmsHeaders;
        }
    }
}

