/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.common;

import java.util.Arrays;
import java.util.Optional;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import org.apache.commons.lang3.StringUtils;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.api.destination.DestinationTypeDescriptor;
import org.mule.jms.commons.api.exception.JmsAckException;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsAckMode;
import org.mule.jms.commons.internal.connection.JmsConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsCommons {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsCommons.class);
    public static final String TOPIC = "TOPIC";
    public static final String QUEUE = "QUEUE";
    public static final String EXAMPLE_ENCODING = "UTF-8";
    public static final String EXAMPLE_CONTENT_TYPE = "application/json";

    public static String resolveMessageContentType(Message message, String defaultType) {
        try {
            String contentType = message.getStringProperty("MM_MESSAGE_CONTENT_TYPE");
            return StringUtils.isBlank((CharSequence)contentType) ? defaultType : contentType;
        }
        catch (JMSException e) {
            LOGGER.warn(String.format("Failed to read the Message ContentType from its properties. A default value of [%s] will be used.", defaultType));
            return defaultType;
        }
    }

    public static String resolveMessageEncoding(Message message, String defaultType) {
        try {
            String contentType = message.getStringProperty("MM_MESSAGE_ENCODING");
            return StringUtils.isBlank((CharSequence)contentType) ? defaultType : contentType;
        }
        catch (JMSException e) {
            LOGGER.warn(String.format("Failed to read the Message ContentType from its properties. A default value of [%s] will be used.", defaultType));
            return defaultType;
        }
    }

    public static <T> T resolveOverride(T configValue, T operationValue) {
        return operationValue == null ? configValue : operationValue;
    }

    public static void evaluateMessageAck(InternalAckMode ackMode, JmsSession session, Message receivedMessage, JmsSessionManager messageSessionManager, JmsListenerLock jmsLock) throws JmsAckException {
        try {
            if (ackMode.equals((Object)InternalAckMode.IMMEDIATE)) {
                LOGGER.debug("Immediate ACK. Automatically performing an ACK over the message.");
                receivedMessage.acknowledge();
            } else if (ackMode.equals((Object)InternalAckMode.MANUAL)) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Manual ACK. Registering pending ACK on session with ID: " + session.getAckId());
                }
                String id = session.getAckId().orElseThrow(() -> new IllegalArgumentException("An AckId is required when MANUAL AckMode is set"));
                messageSessionManager.registerMessageForAck(id, receivedMessage, session.get(), jmsLock);
            }
        }
        catch (JMSException e) {
            throw new JmsAckException("An error occurred while acknowledging the message", (Exception)((Object)e));
        }
    }

    public static JmsSession createJmsSession(JmsConnection jmsConnection, InternalAckMode ackMode, boolean isTopic, JmsSessionManager jmsSessionManager, OperationTransactionalAction transactionalAction) throws JMSException {
        return !transactionalAction.equals((Object)OperationTransactionalAction.NOT_SUPPORTED) ? JmsCommons.getOrCreateTransactedSession(jmsConnection, ackMode, isTopic, jmsSessionManager, jmsSessionManager.getTransactedSession()) : jmsConnection.createSession(ackMode, isTopic);
    }

    public static InternalAckMode toInternalAckMode(JmsAckMode jmsAckMode) {
        return jmsAckMode == null ? null : jmsAckMode.getInternalAckMode();
    }

    public static void releaseResources(JmsSession session, JmsSessionManager sessionManager, AutoCloseable ... closeables) {
        Arrays.stream(closeables).forEach(JmsCommons::closeQuietly);
        if (!JmsCommons.isManualAck(session) && JmsCommons.isPartOfCurrentTx(session, sessionManager)) {
            JmsCommons.closeQuietly(session);
        }
    }

    private static boolean isManualAck(JmsSession session) {
        return session.getAckId().isPresent();
    }

    private static boolean isPartOfCurrentTx(JmsSession session, JmsSessionManager sessionManager) {
        return !sessionManager.getTransactedSession().isPresent() || sessionManager.getTransactedSession().get() != session;
    }

    public static void closeQuietly(AutoCloseable closable) {
        if (closable != null) {
            try {
                closable.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close jms connection resource: ", (Throwable)e);
            }
        }
    }

    public static String getDestinationType(ConsumerType consumerType) {
        return consumerType.topic() ? TOPIC : QUEUE;
    }

    public static String getDestinationType(DestinationTypeDescriptor consumerType) {
        return consumerType.isTopic() ? TOPIC : QUEUE;
    }

    public static String getDestinationType(Destination consumerType) {
        return consumerType instanceof Topic ? TOPIC : QUEUE;
    }

    private static JmsSession getOrCreateTransactedSession(JmsConnection jmsConnection, InternalAckMode ackMode, boolean isTopic, JmsSessionManager jmsSessionManager, Optional<JmsSession> transactedSession) throws JMSException {
        JmsSession session;
        if (transactedSession.isPresent()) {
            session = transactedSession.get();
        } else {
            switch (jmsSessionManager.getTransactionStatus()) {
                case STARTED: {
                    ackMode = InternalAckMode.TRANSACTED;
                    session = jmsConnection.createSession(ackMode, isTopic);
                    jmsSessionManager.bindToTransaction(session);
                    break;
                }
                default: {
                    session = jmsConnection.createSession(ackMode, isTopic);
                }
            }
        }
        return session;
    }
}

