/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection;

import java.util.Optional;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.connection.JmsConnection;
import org.mule.jms.commons.internal.connection.exception.CompositeJmsExceptionListener;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.connection.session.TransactionStatus;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsTransactionalConnection
extends JmsConnection
implements TransactionalConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsTransactionalConnection.class);
    private static final String COMMIT = "Commit";
    private static final String ROLLBACK = "Rollback";

    public JmsTransactionalConnection(JmsSupport jmsSupport, Connection connection, JmsSessionManager jmsSessionManager, CompositeJmsExceptionListener exceptionListener) {
        super(jmsSupport, connection, jmsSessionManager, exceptionListener);
    }

    public void begin() {
        this.jmsSessionManager.changeTransactionStatus(TransactionStatus.STARTED);
    }

    public void commit() throws TransactionException {
        try {
            this.executeTransactionAction(COMMIT, Session::commit);
        }
        catch (Exception e) {
            throw new TransactionException(I18nMessageFactory.createStaticMessage((String)("Could not commit transaction: " + e.getMessage())), (Throwable)e);
        }
    }

    public void rollback() throws TransactionException {
        try {
            this.executeTransactionAction(ROLLBACK, Session::rollback);
        }
        catch (Exception e) {
            throw new TransactionException(I18nMessageFactory.createStaticMessage((String)("Could not rollback transaction: " + e.getMessage())), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTransactionAction(String action, SessionAction transactionalAction) throws JMSException {
        Optional<JmsSession> transactedSession = this.jmsSessionManager.getTransactedSession();
        Preconditions.checkState((boolean)transactedSession.isPresent(), (String)("Unable to " + action + " transaction, the TX Session doesn't exist."));
        JmsSession internalJmsSession = transactedSession.get();
        Session jmsSession = internalJmsSession.get();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("JMS Transaction " + action + " over Session [" + jmsSession + "]");
        }
        try {
            transactionalAction.execute(jmsSession);
        }
        finally {
            JmsCommons.closeQuietly(internalJmsSession);
            this.jmsSessionManager.changeTransactionStatus(TransactionStatus.NONE);
            this.jmsSessionManager.unbindSession();
        }
    }

    @FunctionalInterface
    private static interface SessionAction {
        public void execute(Session var1) throws JMSException;
    }
}

