/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection.session;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.mule.jms.commons.internal.connection.XaJmsResourceWrapper;
import org.mule.jms.commons.internal.connection.session.AckCallback;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsXASession;
import org.mule.jms.commons.internal.connection.session.SessionInformation;
import org.mule.jms.commons.internal.connection.session.TransactionInformation;
import org.mule.jms.commons.internal.connection.session.TransactionStatus;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsSessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsSessionManager.class);
    private final Map<String, SessionInformation> pendingSessions = new HashMap<String, SessionInformation>();
    private final ThreadLocal<TransactionInformation> transactionInformation = new ThreadLocal();

    public void registerMessageForAck(String ackId, Message message, Session session, JmsListenerLock jmsLock) {
        if (!this.pendingSessions.containsKey(ackId)) {
            this.pendingSessions.put(ackId, new SessionInformation(message, session, jmsLock));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Registered Message for Session AckId [" + ackId + "]");
        }
    }

    public void ack(String ackId, AckCallback ackCallback) {
        Optional<SessionInformation> optionalSession = this.getSessionInformation(ackId);
        if (optionalSession.isPresent()) {
            Optional<JmsListenerLock> jmsListenerLock = optionalSession.get().getJmsListenerLock();
            if (jmsListenerLock.isPresent()) {
                jmsListenerLock.get().executeOnListenerThread(() -> {
                    try {
                        ((SessionInformation)optionalSession.get()).getMessage().acknowledge();
                        ackCallback.onSuccess();
                    }
                    catch (JMSException e) {
                        ackCallback.onError(e);
                    }
                });
            } else {
                try {
                    optionalSession.get().getMessage().acknowledge();
                    ackCallback.onSuccess();
                }
                catch (JMSException e) {
                    ackCallback.onError(e);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Acknowledged Message for Session with AckId [" + ackId + "]");
            }
        } else {
            ackCallback.onSuccess();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("The session could not be acknowledged. This may be due to: \n - The session has been already acknowledged\n- The session has been recovered\n - The given 'ackId' :  [" + ackId + "] is invalid.");
            }
        }
    }

    public void recoverSession(String ackId, AckCallback ackCallback) {
        Optional<SessionInformation> optionalSession = this.getSessionInformation(ackId);
        if (optionalSession.isPresent()) {
            SessionInformation sessionInformation = optionalSession.get();
            Optional<JmsListenerLock> jmsListenerLock = sessionInformation.getJmsListenerLock();
            if (jmsListenerLock.isPresent()) {
                jmsListenerLock.get().executeOnListenerThread(() -> {
                    try {
                        ((SessionInformation)optionalSession.get()).getSession().recover();
                        ackCallback.onSuccess();
                    }
                    catch (JMSException e) {
                        ackCallback.onError(e);
                    }
                });
            } else {
                try {
                    optionalSession.get().getSession().recover();
                    ackCallback.onSuccess();
                }
                catch (JMSException e) {
                    ackCallback.onError(e);
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Recovered session for AckId [ " + ackId + "]");
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("The session could not be recovered, this could be due to: \n- The session has been already recovered\n- The all session messages has been already acknowledged\n- The given 'ackId' : [" + ackId + "] is invalid");
        }
    }

    private Optional<SessionInformation> getSessionInformation(String ackId) {
        return Optional.ofNullable(this.pendingSessions.remove(ackId));
    }

    public void bindToTransaction(JmsSession session) {
        this.getTransactionInformation().setJmsSession(session);
    }

    public void bindToTransaction(JmsXASession session, XaJmsResourceWrapper xaSession) {
        this.getTransactionInformation().setJmsSession(session);
        this.getTransactionInformation().setXaResource(xaSession);
    }

    public void unbindSession() {
        this.transactionInformation.remove();
    }

    public Optional<JmsSession> getTransactedSession() {
        return Optional.ofNullable(this.getTransactionInformation().getJmsSession());
    }

    public TransactionStatus getTransactionStatus() {
        TransactionStatus transactionStatus = this.getTransactionInformation().getTransactionStatus();
        return transactionStatus != null ? transactionStatus : TransactionStatus.NONE;
    }

    public void changeTransactionStatus(TransactionStatus transactionStatus) {
        this.getTransactionInformation().setTransactionStatus(transactionStatus);
    }

    private TransactionInformation getTransactionInformation() {
        TransactionInformation transactionInformation = this.transactionInformation.get();
        if (transactionInformation == null) {
            transactionInformation = new TransactionInformation();
            this.transactionInformation.set(transactionInformation);
        }
        return transactionInformation;
    }

    public Optional<XaJmsResourceWrapper> getXaResource() {
        return Optional.ofNullable(this.getTransactionInformation().getXaResource());
    }
}

