/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.operation.publishconsume;

import javax.jms.CompletionListener;
import javax.jms.Message;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.runtime.api.scheduler.Scheduler;

public class ResourceCloserCompletionListener
implements CompletionListener {
    private CompletionListener delegate;
    private JmsSession producerSession;
    private AutoCloseable closeable;
    private final Scheduler scheduler;
    private final JmsSessionManager sessionManager;

    public ResourceCloserCompletionListener(CompletionListener delegate, JmsSession jmsSession, AutoCloseable closeable, Scheduler scheduler, JmsSessionManager sessionManager) {
        this.delegate = delegate;
        this.producerSession = jmsSession;
        this.closeable = closeable;
        this.scheduler = scheduler;
        this.sessionManager = sessionManager;
    }

    public void onCompletion(Message message) {
        this.scheduler.submit(() -> JmsCommons.releaseResources(this.producerSession, this.sessionManager, this.closeable));
        this.delegate.onCompletion(message);
    }

    public void onException(Message message, Exception exception) {
        this.scheduler.submit(() -> JmsCommons.releaseResources(this.producerSession, this.sessionManager, this.closeable));
        this.delegate.onException(message, exception);
    }
}

