/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.source;

import java.util.concurrent.Semaphore;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;

public class DefaultJmsListenerLock
implements JmsListenerLock {
    private Semaphore semaphore = new Semaphore(0);
    private boolean isFailure = false;
    private boolean isUnlocked = false;
    private Throwable cause;
    private Runnable action;

    @Override
    public void lock() {
        this.isUnlocked = false;
        try {
            while (!this.isUnlocked) {
                this.semaphore.acquire();
                if (this.action == null) continue;
                this.action.run();
                this.action = null;
            }
        }
        catch (InterruptedException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The JMS Listener Lock has been interrupted."), this.cause);
        }
        if (this.isFailure) {
            throw new MuleRuntimeException(this.cause);
        }
    }

    @Override
    public void unlockWithFailure(Error error) {
        this.isFailure = true;
        this.isUnlocked = true;
        this.cause = error.getCause();
        this.releaseIfNecessary();
    }

    @Override
    public void unlockWithFailure() {
        this.isFailure = true;
        this.isUnlocked = true;
        this.cause = new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"The JMS Lock has been unlocked indicating that a session recover should be executed."));
        this.releaseIfNecessary();
    }

    @Override
    public void unlock() {
        this.isFailure = false;
        this.isUnlocked = true;
        this.releaseIfNecessary();
    }

    @Override
    public boolean isLocked() {
        return this.semaphore.availablePermits() == 0;
    }

    @Override
    public void executeOnListenerThread(Runnable runnable) {
        this.action = runnable;
        this.releaseIfNecessary();
    }

    private void releaseIfNecessary() {
        if (this.isLocked()) {
            this.semaphore.release();
        }
    }
}

