/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.connection.session.JmsXASession;
import org.mule.jms.commons.internal.connection.session.TransactionStatus;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.transaction.xa.ResourceManagerException;
import org.mule.runtime.core.api.util.queue.Queue;
import org.mule.runtime.core.api.util.queue.QueueSession;

public class XaJmsResourceWrapper
implements QueueSession {
    private final JmsXASession xaSession;
    private XAResource xaResource;
    private JmsSessionManager jmsSessionManager;
    private Runnable runnable;

    public XaJmsResourceWrapper(JmsXASession xaSession, JmsSessionManager jmsSessionManager) {
        this.xaSession = xaSession;
        this.xaResource = xaSession.getXaResource();
        Preconditions.checkArgument((this.xaResource != null ? 1 : 0) != 0, (String)"XA Session provided a NULL XA Resource");
        this.jmsSessionManager = jmsSessionManager;
    }

    public Queue getQueue(String name) {
        return null;
    }

    public void begin() throws ResourceManagerException {
    }

    public void commit() throws ResourceManagerException {
    }

    public void rollback() throws ResourceManagerException {
    }

    public void commit(Xid xid, boolean b) throws XAException {
        this.xaResource.commit(xid, b);
        JmsCommons.closeQuietly(this.xaSession);
    }

    public void end(Xid xid, int i) throws XAException {
        this.xaResource.end(xid, i);
        this.jmsSessionManager.changeTransactionStatus(TransactionStatus.NONE);
        this.jmsSessionManager.unbindSession();
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public void forget(Xid xid) throws XAException {
        this.xaResource.forget(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.xaResource.getTransactionTimeout();
    }

    public boolean isSameRM(XAResource xaResource) throws XAException {
        return xaResource.isSameRM(xaResource);
    }

    public int prepare(Xid xid) throws XAException {
        return this.xaResource.prepare(xid);
    }

    public Xid[] recover(int i) throws XAException {
        return this.xaResource.recover(i);
    }

    public void rollback(Xid xid) throws XAException {
        this.xaResource.rollback(xid);
        JmsCommons.closeQuietly(this.xaSession);
    }

    public boolean setTransactionTimeout(int i) throws XAException {
        return this.xaResource.setTransactionTimeout(i);
    }

    public void start(Xid xid, int i) throws XAException {
        this.xaResource.start(xid, i);
        this.jmsSessionManager.changeTransactionStatus(TransactionStatus.STARTED);
    }

    public void afterEnds(Runnable runnable) {
        this.runnable = runnable;
    }
}

