/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.consume;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.CompletionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.apache.commons.lang3.time.StopWatch;
import org.mule.jms.commons.api.exception.JmsConsumeException;
import org.mule.jms.commons.api.exception.JmsTimeoutException;
import org.mule.jms.commons.internal.message.JmsResultFactory;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsMessageConsumer
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageConsumer.class);
    private final MessageConsumer consumer;
    private final JmsResultFactory resultFactory = JmsResultFactory.getInstance();

    public JmsMessageConsumer(MessageConsumer consumer) {
        Preconditions.checkArgument((consumer != null ? 1 : 0) != 0, (String)"A non null MessageConsumer is required to use as delegate");
        this.consumer = consumer;
    }

    public void listen(MessageListener listener) throws JMSException {
        this.consumer.setMessageListener(listener);
    }

    public Message consume(Long maximumWaitTime) throws JMSException, JmsTimeoutException {
        if (maximumWaitTime == -1L) {
            return this.receive();
        }
        if (maximumWaitTime == 0L) {
            return this.receiveNoWait();
        }
        return this.receiveWithTimeout(maximumWaitTime);
    }

    @Override
    public void close() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing consumer " + this.consumer);
        }
        this.consumer.close();
    }

    private Message receiveWithTimeout(Long maximumWaitTime) throws JMSException, JmsTimeoutException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Waiting for a message, timeout will be in [%s] millis", maximumWaitTime));
        }
        StopWatch timeoutValidator = new StopWatch();
        timeoutValidator.start();
        Message message = this.consumer.receive(maximumWaitTime.longValue());
        timeoutValidator.stop();
        if (message == null && timeoutValidator.getTime() >= maximumWaitTime) {
            throw new JmsTimeoutException("Failed to retrieve a Message, operation timed out");
        }
        return message;
    }

    private Message receiveNoWait() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to consume an immediately available message");
        }
        return this.consumer.receiveNoWait();
    }

    private Message receive() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No Timeout set, waiting for a message until one arrives");
        }
        return this.consumer.receive();
    }

    public MessageConsumer get() {
        return this.consumer;
    }

    public void consume(Long maximumWaitTime, Scheduler scheduler, CompletionListener completionListener) {
        if (maximumWaitTime == -1L) {
            this.listenForMessage(completionListener);
        } else if (maximumWaitTime == 0L) {
            try {
                completionListener.onCompletion(this.consumer.receiveNoWait());
            }
            catch (Exception e) {
                completionListener.onException(null, e);
            }
        } else {
            this.listenForMessage(maximumWaitTime, scheduler, completionListener);
        }
    }

    private void listenForMessage(Long maximumWaitTime, Scheduler scheduler, CompletionListener completionListener) {
        AtomicBoolean messageReceived = new AtomicBoolean(false);
        AtomicBoolean isClosing = new AtomicBoolean(false);
        Reference schedule = new Reference();
        try {
            this.consumer.setMessageListener(message -> {
                messageReceived.set(true);
                if (schedule.get() != null) {
                    ((ScheduledFuture)schedule.get()).cancel(true);
                }
                try {
                    MessageConsumer messageConsumer = this.consumer;
                    synchronized (messageConsumer) {
                        if (!isClosing.getAndSet(true) && this.consumer.getMessageListener() != null) {
                            this.consumer.setMessageListener(null);
                        }
                    }
                }
                catch (JMSException e) {
                    LOGGER.warn("An unknown error occurred trying to shutdown a listener.", (Throwable)e);
                }
                completionListener.onCompletion(message);
            });
        }
        catch (JMSException e) {
            completionListener.onException(null, (Exception)((Object)e));
        }
        if (maximumWaitTime > 0L) {
            schedule.set((Object)scheduler.schedule(() -> {
                if (!messageReceived.get()) {
                    try {
                        MessageConsumer messageConsumer = this.consumer;
                        synchronized (messageConsumer) {
                            isClosing.getAndSet(true);
                            if (this.consumer.getMessageListener() != null) {
                                this.consumer.setMessageListener(null);
                            }
                        }
                        if (!messageReceived.get()) {
                            completionListener.onException(null, (Exception)((Object)new JmsTimeoutException(String.format("Failed to retrieve a Message. Operation timed out after %s milliseconds", maximumWaitTime))));
                        }
                    }
                    catch (JMSException e) {
                        completionListener.onException(null, (Exception)((Object)new JmsConsumeException("Unable to listen for message.", (Exception)((Object)e))));
                    }
                }
            }, maximumWaitTime.longValue(), TimeUnit.MILLISECONDS));
        }
    }

    private void listenForMessage(CompletionListener completionListener) {
        this.listenForMessage(-1L, null, completionListener);
    }
}

