/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.message;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageEOFException;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.mule.jms.commons.api.connection.JmsSpecification;
import org.mule.jms.commons.api.exception.JmsIllegalBodyException;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.message.OutputHandler;
import org.mule.runtime.core.api.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsMessageUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageUtils.class);
    private static final char REPLACEMENT_CHAR = '_';

    public static Message toMessage(TypedValue<Object> typedValueObject, Session session) throws JMSException {
        Object object = typedValueObject.getValue();
        if (object instanceof CursorProvider) {
            object = ((CursorProvider)object).openCursor();
        }
        if (object == null) {
            throw new JmsIllegalBodyException("Message body was 'null', which is not a value of a supported type");
        }
        if (object instanceof Message) {
            return (Message)object;
        }
        if (object instanceof String) {
            return JmsMessageUtils.stringToMessage((String)object, session);
        }
        if (object instanceof Map && JmsMessageUtils.validateMapMessageType((Map)object)) {
            return JmsMessageUtils.mapToMessage((Map)object, session);
        }
        if (object instanceof InputStream) {
            if (MediaTypeUtils.isStringRepresentable((MediaType)typedValueObject.getDataType().getMediaType())) {
                return JmsMessageUtils.stringToMessage(IOUtils.toString((InputStream)((InputStream)object)), session);
            }
            return JmsMessageUtils.byteArrayToMessage(IOUtils.toByteArray((InputStream)((InputStream)object)), session);
        }
        if (object instanceof Collection) {
            return JmsMessageUtils.collectionToMessage((Collection)object, session);
        }
        if (object instanceof Iterator) {
            return JmsMessageUtils.iteratorToMessage((Iterator)object, session);
        }
        if (object instanceof byte[]) {
            return JmsMessageUtils.byteArrayToMessage((byte[])object, session);
        }
        if (object instanceof Serializable) {
            return JmsMessageUtils.serializableToMessage((Serializable)object, session);
        }
        if (object instanceof OutputHandler) {
            return JmsMessageUtils.outputHandlerToMessage((OutputHandler)object, session);
        }
        throw new JmsIllegalBodyException("Message body was not of a supported type. Valid types are Message, String, Map, InputStream, List, byte[], Serializable or OutputHandler, but was " + JmsMessageUtils.getClassName(object));
    }

    static Map<String, Object> getPropertiesMap(Message jmsMessage) {
        HashMap<String, Object> properties;
        block5: {
            properties = new HashMap<String, Object>();
            try {
                Enumeration e = jmsMessage.getPropertyNames();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    try {
                        Object value = jmsMessage.getObjectProperty(key);
                        if (value == null) continue;
                        properties.put(key, value);
                    }
                    catch (JMSException e1) {
                        if (!LOGGER.isDebugEnabled()) continue;
                        LOGGER.debug("An error occurred while retrieving a JMS property: ", (Throwable)e1);
                    }
                }
            }
            catch (JMSException e2) {
                if (!LOGGER.isDebugEnabled()) break block5;
                LOGGER.debug("An error occurred while retrieving the JMS Message properties: ", (Throwable)e2);
            }
        }
        return properties;
    }

    public static String encodeKey(String name) {
        int i;
        boolean nonCompliant = false;
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)name) ? 1 : 0) != 0, (String)"Header name to encode cannot be blank");
        int length = name.length();
        for (i = 0; i < length && Character.isJavaIdentifierPart(name.charAt(i)); ++i) {
        }
        if (i == length) {
            return name;
        }
        StringBuilder sb = new StringBuilder(name);
        for (int j = i; j < length; ++j) {
            if (Character.isJavaIdentifierPart(sb.charAt(j))) continue;
            sb.setCharAt(j, '_');
            nonCompliant = true;
        }
        if (nonCompliant) {
            LOGGER.warn(String.format("Header: %s is not compliant with JMS specification (sec. 3.5.1, 3.8.1.1). It will cause problems in other applications. Please update your application code to correct this. Mule renamed it to %s", name, sb.toString()));
        }
        return sb.toString();
    }

    private static String getClassName(Object object) {
        return object == null ? "null" : object.getClass().getName();
    }

    private static Message stringToMessage(String value, Session session) throws JMSException {
        return session.createTextMessage(value);
    }

    private static Message mapToMessage(Map<?, ?> value, Session session) throws JMSException {
        MapMessage mMsg = session.createMapMessage();
        for (Map.Entry<?, ?> entry : value.entrySet()) {
            mMsg.setObject(entry.getKey().toString(), entry.getValue());
        }
        return mMsg;
    }

    private static void closeQuietly(InputStream inputStream) {
        block2: {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failure closing InputStream " + e.getMessage());
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private static void addObjectToStreamMessage(StreamMessage sMsg, Object o) throws JMSException {
        if (!JmsMessageUtils.validateStreamMessageType(o)) {
            throw new JmsIllegalBodyException(String.format("Invalid type passed to StreamMessage: %s . Allowed types are: Boolean, Byte, Short, Character, Integer, Long, Float, Double,String and byte[]", JmsMessageUtils.getClassName(o)));
        }
        sMsg.writeObject(o);
    }

    private static Message byteArrayToMessage(byte[] value, Session session) throws JMSException {
        BytesMessage bMsg = session.createBytesMessage();
        bMsg.writeBytes(value);
        return bMsg;
    }

    private static Message serializableToMessage(Serializable value, Session session) throws JMSException {
        ObjectMessage oMsg = session.createObjectMessage();
        oMsg.setObject(value);
        return oMsg;
    }

    private static Message iteratorToMessage(Iterator iterator, Session session) throws JMSException {
        StreamMessage sMsg = session.createStreamMessage();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            JmsMessageUtils.addObjectToStreamMessage(sMsg, o);
        }
        return sMsg;
    }

    private static Message collectionToMessage(Collection<?> value, Session session) throws JMSException {
        StreamMessage sMsg = session.createStreamMessage();
        for (Object o : value) {
            JmsMessageUtils.addObjectToStreamMessage(sMsg, o);
        }
        return sMsg;
    }

    private static Message outputHandlerToMessage(OutputHandler value, Session session) throws JMSException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            value.write(null, (OutputStream)output);
        }
        catch (IOException e) {
            throw new JmsIllegalBodyException("Could not serialize OutputHandler.", e);
        }
        BytesMessage bMsg = session.createBytesMessage();
        bMsg.writeBytes(output.toByteArray());
        return bMsg;
    }

    static Object toObject(Message source, JmsSpecification jmsSpec, String encoding) throws JMSException, IOException {
        if (source instanceof ObjectMessage) {
            return ((ObjectMessage)source).getObject();
        }
        if (source instanceof MapMessage) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            MapMessage m = (MapMessage)source;
            Enumeration e = m.getMapNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                Object obj = m.getObject(name);
                map.put(name, obj);
            }
            return map;
        }
        if (source instanceof TextMessage) {
            return ((TextMessage)source).getText();
        }
        if (source instanceof BytesMessage) {
            return JmsMessageUtils.toByteArray(source, jmsSpec, encoding);
        }
        if (source instanceof StreamMessage) {
            ArrayList<Object> result = new ArrayList<Object>();
            try {
                Object obj;
                StreamMessage sMsg = (StreamMessage)source;
                while ((obj = sMsg.readObject()) != null) {
                    result.add(obj);
                }
            }
            catch (MessageEOFException sMsg) {
            }
            catch (Exception e) {
                throw new JmsIllegalBodyException("Failed to extract information from JMS Stream Message: " + e);
            }
            return result;
        }
        return source;
    }

    private static byte[] toByteArray(Message message, JmsSpecification jmsSpec, String encoding) throws JMSException, IOException {
        if (message instanceof BytesMessage) {
            int len;
            BytesMessage bMsg = (BytesMessage)message;
            bMsg.reset();
            if (JmsSpecification.JMS_1_1.equals((Object)jmsSpec)) {
                long bmBodyLength = bMsg.getBodyLength();
                if (bmBodyLength > Integer.MAX_VALUE) {
                    throw new JmsIllegalBodyException("Size of BytesMessage exceeds Integer.MAX_VALUE; please consider using JMS StreamMessage instead");
                }
                if (bmBodyLength > 0L) {
                    byte[] bytes = new byte[(int)bmBodyLength];
                    bMsg.readBytes(bytes);
                    return bytes;
                }
                return ArrayUtils.EMPTY_BYTE_ARRAY;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            byte[] buffer = new byte[4096];
            while ((len = bMsg.readBytes(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            if (baos.size() > 0) {
                return baos.toByteArray();
            }
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        if (message instanceof StreamMessage) {
            int len;
            StreamMessage sMsg = (StreamMessage)message;
            sMsg.reset();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
            byte[] buffer = new byte[4096];
            while ((len = sMsg.readBytes(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
            return baos.toByteArray();
        }
        if (message instanceof ObjectMessage) {
            ObjectMessage oMsg = (ObjectMessage)message;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream((OutputStream)baos);
            os.writeObject(oMsg.getObject());
            os.flush();
            os.close();
            return baos.toByteArray();
        }
        if (message instanceof TextMessage) {
            TextMessage tMsg = (TextMessage)message;
            String tMsgText = tMsg.getText();
            if (null == tMsgText) {
                return ArrayUtils.EMPTY_BYTE_ARRAY;
            }
            return tMsgText.getBytes(encoding);
        }
        throw new JmsIllegalBodyException("Cannot get bytes from Map Message");
    }

    private static boolean validateStreamMessageType(Object candidate) {
        return candidate == null || candidate instanceof Boolean || candidate instanceof Byte || candidate instanceof Short || candidate instanceof Character || candidate instanceof Integer || candidate instanceof Long || candidate instanceof Float || candidate instanceof Double || candidate instanceof String || candidate instanceof byte[];
    }

    private static boolean validateMapMessageType(Map<?, ?> candidate) {
        return candidate.values().stream().allMatch(JmsMessageUtils::validateStreamMessageType);
    }
}

