/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.source.push;

import java.util.ArrayList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.api.exception.JmsExtensionException;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.consume.JmsMessageConsumer;
import org.mule.jms.commons.internal.source.DefaultJmsListenerLock;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.mule.jms.commons.internal.source.MessageConsumerDelegate;
import org.mule.jms.commons.internal.source.NullJmsListenerLock;
import org.mule.jms.commons.internal.source.push.JmsMessageListenerFactory;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsMessageListenerDelegate
implements MessageConsumerDelegate {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageListenerDelegate.class);
    private JmsMessageListenerFactory messageListenerFactory;
    private JmsConnection connection;
    private final JmsSupport jmsSupport;
    private final ConsumerType consumerType;
    private final String destination;
    private final JmsConfig config;
    private final InternalAckMode resolvedAckMode;
    private final String selector;
    private final List<MessageListenerInfo> createdListeners = new ArrayList<MessageListenerInfo>();
    static final String JMS_LOCK_VAR = "JMS_LOCK";

    public JmsMessageListenerDelegate(JmsMessageListenerFactory messageListenerFactory, JmsConnection connection, JmsSupport jmsSupport, ConsumerType consumerType, String destination, JmsConfig config, InternalAckMode resolvedAckMode, String selector) {
        this.messageListenerFactory = messageListenerFactory;
        this.connection = connection;
        this.jmsSupport = jmsSupport;
        this.consumerType = consumerType;
        this.destination = destination;
        this.config = config;
        this.resolvedAckMode = resolvedAckMode;
        this.selector = selector;
    }

    @Override
    public void createConsumers(int numberOfConsumers) throws ConnectionException {
        try {
            for (int i = 0; i < numberOfConsumers; ++i) {
                JmsSession session = this.connection.createSession(this.resolvedAckMode, this.consumerType.topic());
                Destination jmsDestination = this.jmsSupport.createDestination(session.get(), this.destination, this.consumerType.topic(), this.config);
                JmsMessageConsumer consumer = this.connection.createConsumer(session, jmsDestination, this.selector, this.consumerType);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Creating Message Listener on Session [%s] for destination [%s]", session.get(), this.destination));
                }
                JmsListenerLock jmsLock = this.createJmsLock();
                this.createdListeners.add(new MessageListenerInfo(session, jmsLock, consumer));
                consumer.listen(this.messageListenerFactory.createMessageListener(session, jmsLock));
            }
        }
        catch (JMSException | JmsExtensionException e) {
            String msg = String.format("An error occurred while creating the consumers for destination [%s:%s]: %s", JmsCommons.getDestinationType(this.consumerType), this.destination, ((Throwable)e).getMessage());
            LOGGER.error(msg, (Throwable)e);
            this.stop();
            throw new ConnectionException(msg, (Throwable)e, null, (Object)this.connection);
        }
    }

    @Override
    public void onSuccess(SourceCallbackContext callbackContext) {
        callbackContext.getVariable(JMS_LOCK_VAR).ifPresent(JmsListenerLock::unlock);
    }

    @Override
    public void stop() {
        try {
            this.createdListeners.forEach(info -> {
                info.getLock().unlockWithFailure();
                this.closeConsumer(info.getConsumer());
                JmsCommons.closeQuietly(info.getSession());
            });
        }
        finally {
            this.createdListeners.clear();
        }
    }

    private void closeConsumer(JmsMessageConsumer consumer) {
        try {
            consumer.listen(null);
        }
        catch (JMSException e) {
            LOGGER.error(String.format("An unexpected error occurred trying to turn off a MessageListener [%s].", consumer), (Throwable)e);
        }
        JmsCommons.closeQuietly(consumer);
    }

    @Override
    public void onError(SourceCallbackContext callbackContext, Error error) {
        callbackContext.getVariable(JMS_LOCK_VAR).ifPresent(jmsLock -> {
            if (this.resolvedAckMode.equals((Object)InternalAckMode.AUTO) || this.resolvedAckMode.equals((Object)InternalAckMode.DUPS_OK)) {
                jmsLock.unlockWithFailure(error);
            } else {
                jmsLock.unlock();
            }
        });
    }

    private JmsListenerLock createJmsLock() {
        if (this.resolvedAckMode.equals((Object)InternalAckMode.IMMEDIATE) || this.resolvedAckMode.equals((Object)InternalAckMode.TRANSACTED)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(String.format("Session lock skipped for ACK mode [%s].", this.resolvedAckMode.name()));
            }
            return new NullJmsListenerLock();
        }
        return new DefaultJmsListenerLock();
    }

    public static class MessageListenerInfo {
        private JmsSession session;
        private JmsListenerLock jmsListenerLock;
        private JmsMessageConsumer messageConsumer;

        MessageListenerInfo(JmsSession session, JmsListenerLock jmsListenerLock, JmsMessageConsumer messageConsumer) {
            this.session = session;
            this.jmsListenerLock = jmsListenerLock;
            this.messageConsumer = messageConsumer;
        }

        public JmsSession getSession() {
            return this.session;
        }

        public JmsListenerLock getLock() {
            return this.jmsListenerLock;
        }

        public JmsMessageConsumer getConsumer() {
            return this.messageConsumer;
        }
    }
}

