/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.support;

import java.util.Optional;
import java.util.function.Function;
import javax.jms.CompletionListener;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import org.apache.commons.lang3.StringUtils;
import org.mule.jms.commons.api.connection.JmsSpecification;
import org.mule.jms.commons.api.connection.LookupJndiDestination;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.api.destination.TopicConsumer;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.support.Jms11Support;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jms102bSupport
extends Jms11Support {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jms102bSupport.class);

    public Jms102bSupport() {
    }

    public Jms102bSupport(LookupJndiDestination lookupJndiDestination, Function<String, Optional<Destination>> jndiObjectSupplier) {
        super(lookupJndiDestination, jndiObjectSupplier);
    }

    @Override
    public JmsSpecification getSpecification() {
        return JmsSpecification.JMS_1_0_2b;
    }

    @Override
    public Connection createConnection(ConnectionFactory connectionFactory, String username, String password) throws JMSException {
        Preconditions.checkArgument((connectionFactory != null ? 1 : 0) != 0, (String)"connectionFactory cannot be null");
        if (connectionFactory instanceof QueueConnectionFactory) {
            return ((QueueConnectionFactory)connectionFactory).createQueueConnection(username, password);
        }
        if (connectionFactory instanceof TopicConnectionFactory) {
            return ((TopicConnectionFactory)connectionFactory).createTopicConnection(username, password);
        }
        throw new IllegalArgumentException("Unsupported ConnectionFactory type: " + connectionFactory.getClass().getName());
    }

    @Override
    public Connection createConnection(ConnectionFactory connectionFactory) throws JMSException {
        Preconditions.checkArgument((connectionFactory != null ? 1 : 0) != 0, (String)"connectionFactory cannot be null");
        if (connectionFactory instanceof QueueConnectionFactory) {
            return ((QueueConnectionFactory)connectionFactory).createQueueConnection();
        }
        if (connectionFactory instanceof TopicConnectionFactory) {
            return ((TopicConnectionFactory)connectionFactory).createTopicConnection();
        }
        throw new IllegalArgumentException("Unsupported ConnectionFactory type: " + connectionFactory.getClass().getName());
    }

    @Override
    public XAConnection createXaConnection(XAConnectionFactory connectionFactory) throws JMSException {
        throw new IllegalStateException("XA Connections are not supported on the JMS Spec 1.0.2b");
    }

    @Override
    public XAConnection createXaConnection(XAConnectionFactory connectionFactory, String username, String password) throws JMSException {
        throw new IllegalStateException("XA Connections are not supported on the JMS Spec 1.0.2b");
    }

    @Override
    public Session createSession(Connection connection, boolean topic, boolean transacted, int ackMode) throws JMSException {
        Preconditions.checkArgument((connection != null ? 1 : 0) != 0, (String)"Connection cannot be null");
        if (topic && connection instanceof TopicConnection) {
            return ((TopicConnection)connection).createTopicSession(transacted, transacted ? 0 : ackMode);
        }
        if (connection instanceof QueueConnection) {
            return ((QueueConnection)connection).createQueueSession(transacted, transacted ? 0 : ackMode);
        }
        throw new IllegalArgumentException("Connection and domain type do not match, connection is of type " + connection.getClass().getName());
    }

    @Override
    public XASession createXaSession(XAConnection connection) throws JMSException {
        throw new IllegalStateException("XA Sessions are not supported on the JMS Spec 1.0.2b");
    }

    @Override
    public MessageConsumer createConsumer(Session session, Destination destination, String messageSelector, ConsumerType type) throws JMSException {
        if (type.topic() && session instanceof TopicSession) {
            TopicConsumer topicConsumer = (TopicConsumer)type;
            if (!topicConsumer.isDurable()) {
                return ((TopicSession)session).createSubscriber((Topic)destination, messageSelector, topicConsumer.isNoLocal());
            }
            return ((TopicSession)session).createDurableSubscriber((Topic)destination, topicConsumer.getSubscriptionName(), messageSelector, topicConsumer.isNoLocal());
        }
        if (session instanceof QueueSession) {
            if (messageSelector != null) {
                return ((QueueSession)session).createReceiver((Queue)destination, messageSelector);
            }
            return ((QueueSession)session).createReceiver((Queue)destination);
        }
        throw new IllegalArgumentException("Session and domain type do not match");
    }

    @Override
    public MessageProducer createProducer(Session session, Destination dest, boolean topic) throws JMSException {
        if (topic && session instanceof TopicSession) {
            return ((TopicSession)session).createPublisher((Topic)dest);
        }
        if (session instanceof QueueSession) {
            return ((QueueSession)session).createSender((Queue)dest);
        }
        throw new IllegalArgumentException("Session and domain type do not match");
    }

    @Override
    public Destination createDestination(Session session, String name, boolean topic, JmsConfig config) throws JMSException {
        Optional<Destination> destination;
        if ((this.getLookupJndiDestination().equals((Object)LookupJndiDestination.ALWAYS) || this.getLookupJndiDestination().equals((Object)LookupJndiDestination.TRY_ALWAYS)) && (destination = this.createDestinationFromJndi(name)).isPresent()) {
            return destination.get();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using non-JNDI destination " + name + ", will create one now");
        }
        if (session == null) {
            throw new IllegalArgumentException("Session cannot be null when creating a destination");
        }
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IllegalArgumentException("Destination name cannot be null when creating a destination");
        }
        if (topic) {
            return ((TopicSession)session).createTopic(name);
        }
        return ((QueueSession)session).createQueue(name);
    }

    @Override
    public TemporaryQueue createTemporaryDestination(Session session) throws JMSException {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (String)"Session cannot be null when creating a destination");
        return ((QueueSession)session).createTemporaryQueue();
    }

    @Override
    public void send(MessageProducer producer, Message message, boolean persistent, int priority, long ttl, boolean topic) throws JMSException {
        int deliveryMode;
        if (LOGGER.isDebugEnabled()) {
            Destination dest = producer.getDestination();
            LOGGER.debug(String.format("Sending message to [%s], persistent:[%s], with priority:[%s] and ttl:[%s]", dest instanceof Queue ? ((Queue)dest).getQueueName() : ((Topic)dest).getTopicName(), persistent, priority, ttl));
        }
        int n = deliveryMode = persistent ? 2 : 1;
        if (topic && producer instanceof TopicPublisher) {
            ((TopicPublisher)producer).publish(message, deliveryMode, priority, ttl);
        } else if (producer instanceof QueueSender) {
            ((QueueSender)producer).send(message, deliveryMode, priority, ttl);
        } else {
            throw new IllegalArgumentException("Producer and domain type do not match");
        }
    }

    @Override
    public void send(MessageProducer producer, Message message, boolean persistent, int priority, long ttl, boolean topic, CompletionListener completionListener) throws JMSException {
        try {
            int deliveryMode;
            if (LOGGER.isDebugEnabled()) {
                Destination dest = producer.getDestination();
                LOGGER.debug(String.format("Sending message to [%s], persistent:[%s], with priority:[%s] and ttl:[%s]", dest instanceof Queue ? ((Queue)dest).getQueueName() : ((Topic)dest).getTopicName(), persistent, priority, ttl));
            }
            int n = deliveryMode = persistent ? 2 : 1;
            if (topic && producer instanceof TopicPublisher) {
                ((TopicPublisher)producer).publish(message, deliveryMode, priority, ttl);
            } else if (producer instanceof QueueSender) {
                ((QueueSender)producer).send(message, deliveryMode, priority, ttl);
            } else {
                throw new IllegalArgumentException("Producer and domain type do not match");
            }
            completionListener.onCompletion(message);
        }
        catch (Exception e) {
            completionListener.onException(message, e);
        }
    }
}

