/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection;

import java.util.Optional;
import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.XAConnection;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.mule.jms.commons.api.exception.JmsExtensionException;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.XaJmsResourceWrapper;
import org.mule.jms.commons.internal.connection.exception.CompositeJmsExceptionListener;
import org.mule.jms.commons.internal.connection.session.DefaultXAJmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.connection.session.JmsXASession;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.connectivity.XATransactionalConnection;

public class JmsXaTransactionalConnection
extends JmsTransactionalConnection
implements XATransactionalConnection {
    private XAConnection connection;
    private JmsSessionManager jmsSessionManager;

    public JmsXaTransactionalConnection(JmsSupport jmsSupport, XAConnection connection, JmsSessionManager jmsSessionManager, CompositeJmsExceptionListener exceptionListener) {
        super(jmsSupport, (Connection)connection, jmsSessionManager, exceptionListener);
        this.connection = connection;
        this.jmsSessionManager = jmsSessionManager;
    }

    public XAResource getXAResource() {
        try {
            Optional<XaJmsResourceWrapper> optionalXAResource = this.jmsSessionManager.getXaResource(this);
            if (optionalXAResource.isPresent()) {
                return (XAResource)((Object)optionalXAResource.get());
            }
            XASession xaSession = this.connection.createXASession();
            XaJmsResourceWrapper xaJmsResourceWrapper = new XaJmsResourceWrapper(new DefaultXAJmsSession(xaSession), this.jmsSessionManager);
            this.jmsSessionManager.bindToTransaction(this, new DefaultXAJmsSession(xaSession), xaJmsResourceWrapper);
            return xaJmsResourceWrapper;
        }
        catch (JMSException e) {
            throw new JmsExtensionException("An error occurred trying to obtain the XA Resource", (Exception)new ConnectionException((Throwable)e));
        }
    }

    public JmsXASession createXaSession() throws JMSException {
        return new DefaultXAJmsSession(this.getJmsSupport().createXaSession(this.connection));
    }

    public void close() {
        this.jmsSessionManager.unbindSession();
    }
}

