/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.api.message;

import java.nio.charset.Charset;
import java.util.Map;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.apache.commons.lang3.StringUtils;
import org.mule.jms.commons.api.destination.DefaultJmsDestination;
import org.mule.jms.commons.api.destination.JmsDestination;
import org.mule.jms.commons.api.exception.DestinationNotFoundException;
import org.mule.jms.commons.api.message.JmsMessageBuilder;
import org.mule.jms.commons.api.message.JmsxProperties;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.message.JMSXDefinedPropertiesNames;
import org.mule.jms.commons.internal.message.JmsMessageUtils;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.parameter.OutboundCorrelationStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJmsMessageBuilder<D extends DefaultJmsDestination>
implements JmsMessageBuilder<D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJmsMessageBuilder.class);
    public static final String BODY_CONTENT_TYPE_JMS_PROPERTY = "MM_MESSAGE_CONTENT_TYPE";
    public static final String BODY_ENCODING_JMS_PROPERTY = "MM_MESSAGE_ENCODING";
    @Parameter
    @ParameterDsl(allowReferences=false)
    @Content(primary=true)
    @Summary(value="The body of the Message")
    private TypedValue<Object> body;
    @Parameter
    @ConfigOverride
    @Summary(value="The JMSType identifier header of the Message")
    private String jmsType;
    @Parameter
    @Optional
    @Summary(value="The JMSCorrelationID header of the Message")
    private String correlationId;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Whether or not the body content type should be sent as a property")
    private boolean sendContentType;
    @Parameter
    @Optional
    @DisplayName(value="ContentType")
    @Example(value="application/json")
    @Summary(value="The content type of the message's body")
    private String outboundContentType;
    @Parameter
    @Optional(defaultValue="true")
    @Summary(value="Whether or not the body outboundEncoding should be sent as a Message property")
    private boolean sendEncoding;
    @Parameter
    @Optional
    @DisplayName(value="Encoding")
    @Example(value="UTF-8")
    @Summary(value="The encoding of the message's body")
    private String outboundEncoding;
    @Parameter
    @Optional
    @Summary(value="The destination where a reply to this Message should be sent")
    private D replyTo;
    @Content
    @Parameter
    @Optional
    @NullSafe
    @DisplayName(value="User Properties")
    @Summary(value="The custom user properties that should be set to this Message")
    private Map<String, Object> properties;
    @Parameter
    @Optional
    @NullSafe
    @DisplayName(value="JMSX Properties")
    @Summary(value="The JMSX properties that should be set to this Message")
    private JmsxProperties jmsxProperties;

    @Override
    public Message build(JmsSupport jmsSupport, OutboundCorrelationStrategy outboundCorrelationStrategy, CorrelationInfo correlationInfo, Session session, JmsConfig config) throws JMSException {
        Message message = JmsMessageUtils.toMessage(this.body, session);
        this.setJmsCorrelationIdHeader(message, outboundCorrelationStrategy, correlationInfo);
        this.setJmsTypeHeader(message);
        this.setJmsReplyToHeader(jmsSupport, session, message, (JmsDestination)this.replyTo, config);
        this.setJmsxProperties(message);
        this.setUserProperties(message);
        if (this.sendContentType) {
            this.setContentTypeProperty(message, this.body.getDataType());
        }
        if (this.sendEncoding) {
            this.setEncodingProperty(message, this.body.getDataType(), JmsCommons.resolveOverride(config.getEncoding(), this.outboundEncoding));
        }
        return message;
    }

    private void setJmsReplyToHeader(JmsSupport jmsSupport, Session session, Message message, JmsDestination replyDestination, JmsConfig config) {
        try {
            if (replyDestination != null && !StringUtils.isBlank((CharSequence)replyDestination.getDestination())) {
                Destination destination = jmsSupport.createDestination(session, replyDestination.getDestination(), replyDestination.getDestinationType().isTopic(), config);
                message.setJMSReplyTo(destination);
            }
        }
        catch (JMSException | DestinationNotFoundException e) {
            LOGGER.error("Unable to set JMSReplyTo header: ", (Throwable)e);
        }
    }

    private void setEncodingProperty(Message message, DataType dataType, String defaultEncoding) {
        try {
            message.setStringProperty(BODY_ENCODING_JMS_PROPERTY, dataType.getMediaType().getCharset().map(Charset::toString).orElse(defaultEncoding));
        }
        catch (JMSException e) {
            LOGGER.error(String.format("Unable to set property [%s] of type String: ", BODY_ENCODING_JMS_PROPERTY), (Throwable)e);
        }
    }

    private void setContentTypeProperty(Message message, DataType dataType) {
        try {
            String value = StringUtils.isBlank((CharSequence)this.outboundContentType) ? dataType.getMediaType().toRfcString() : this.outboundContentType;
            message.setStringProperty(BODY_CONTENT_TYPE_JMS_PROPERTY, value);
        }
        catch (JMSException e) {
            LOGGER.error(String.format("Unable to set property [%s] of type String: ", BODY_CONTENT_TYPE_JMS_PROPERTY), (Throwable)e);
        }
    }

    private void setJmsxProperties(Message message) {
        this.jmsxProperties.asMap().entrySet().stream().filter(e -> e.getValue() != null).forEach(e -> this.setJmsPropertySanitizeKeyIfNecessary(message, (String)e.getKey(), e.getValue()));
    }

    private void setUserProperties(Message message) {
        this.properties.keySet().stream().filter(key -> !StringUtils.isBlank((CharSequence)key) && !JMSXDefinedPropertiesNames.JMSX_NAMES.contains(key)).forEach(key -> this.setJmsPropertySanitizeKeyIfNecessary(message, (String)key, this.properties.get(key)));
    }

    private void setJmsPropertySanitizeKeyIfNecessary(Message msg, String key, Object value) {
        block3: {
            try {
                key = JmsMessageUtils.encodeKey(key);
                if (value instanceof TypedValue) {
                    value = ((TypedValue)value).getValue();
                }
                msg.setObjectProperty(key, value);
            }
            catch (JMSException e) {
                if (!LOGGER.isDebugEnabled()) break block3;
                LOGGER.debug(String.format("Unable to set property [%s] of type [%s]: ", key, value.getClass().getSimpleName()), (Throwable)e);
            }
        }
    }

    private void setJmsTypeHeader(Message message) {
        try {
            if (!StringUtils.isBlank((CharSequence)this.jmsType)) {
                message.setJMSType(this.jmsType);
            }
        }
        catch (JMSException e) {
            LOGGER.error("An error occurred while setting the JMSType property: %s", (Throwable)e);
        }
    }

    private void setJmsCorrelationIdHeader(Message message, OutboundCorrelationStrategy outboundCorrelationStrategy, CorrelationInfo correlationInfo) {
        outboundCorrelationStrategy.getOutboundCorrelationId(correlationInfo, this.correlationId).ifPresent(id -> {
            try {
                message.setJMSCorrelationID(id);
            }
            catch (JMSException e) {
                LOGGER.error("An error occurred while setting the JMSCorrelationID property: %s", (Throwable)e);
            }
        });
    }

    @Override
    public TypedValue<Object> getBody() {
        return this.body;
    }

    @Override
    public boolean isSendContentType() {
        return this.sendContentType;
    }

    @Override
    public String getOutboundContentType() {
        return this.outboundContentType;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public String getJmsType() {
        return this.jmsType;
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public JmsxProperties getJmsxProperties() {
        return this.jmsxProperties;
    }

    @Override
    public JmsDestination getReplyTo() {
        return this.replyTo;
    }

    @Override
    public boolean isSendEncoding() {
        return this.sendEncoding;
    }

    @Override
    public String getOutboundEncoding() {
        return this.outboundEncoding;
    }
}

