/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.message;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.jms.commons.api.message.JmsxProperties;
import org.mule.jms.commons.internal.message.JMSXDefinedPropertiesNames;
import org.mule.runtime.api.util.Preconditions;

public final class JmsxPropertiesBuilder {
    private final Map<String, Object> properties = new HashMap<String, Object>();

    private JmsxPropertiesBuilder() {
    }

    public static JmsxPropertiesBuilder create() {
        return new JmsxPropertiesBuilder();
    }

    public JmsxPropertiesBuilder add(String key, Object value) {
        Preconditions.checkArgument((boolean)JMSXDefinedPropertiesNames.JMSX_NAMES.contains(key), (String)String.format("Invalid key [%s], supported keys for JMSXProperties are [%s]", key, String.join((CharSequence)", ", JMSXDefinedPropertiesNames.JMSX_NAMES)));
        this.properties.put(key, value);
        return this;
    }

    public JmsxProperties build() {
        return new JmsxProperties(Optional.ofNullable(this.properties.get("JMSXUserID")).map(String::valueOf).orElse(null), Optional.ofNullable(this.properties.get("JMSXAppID")).map(String::valueOf).orElse(null), Integer.valueOf(this.properties.getOrDefault("JMSXDeliveryCount", "1").toString()), Optional.ofNullable(this.properties.get("JMSXGroupID")).map(String::valueOf).orElse(null), Integer.valueOf(this.properties.getOrDefault("JMSXGroupSeq", "1").toString()), Optional.ofNullable(this.properties.get("JMSXProducerTXID")).map(String::valueOf).orElse(null), Optional.ofNullable(this.properties.get("JMSXConsumerTXID")).map(String::valueOf).orElse(null), Optional.ofNullable(this.properties.get("JMSXRcvTimestamp")).map(n -> Long.valueOf(n.toString())).orElse(null));
    }
}

