/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.source.push;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.mule.jms.commons.api.connection.JmsSpecification;
import org.mule.jms.commons.api.message.DefaultJmsAttributes;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.source.JmsConnectionExceptionResolver;
import org.mule.jms.commons.internal.source.JmsListener;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.mule.jms.commons.internal.source.JmsMessageDispatcher;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsMessageListener<T extends DefaultJmsAttributes>
implements MessageListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageListener.class);
    private final JmsSession session;
    private final SourceCallback<Object, T> sourceCallback;
    private final JmsListenerLock jmsLock;
    private final JmsMessageDispatcher messageDispacher;
    private final InternalAckMode ackMode;
    private final JmsSessionManager sessionManager;
    private final JmsConnectionExceptionResolver exceptionResolver;
    private ConnectionProvider<JmsTransactionalConnection> connectionProvider;

    JmsMessageListener(JmsSession session, JmsConfig config, JmsListenerLock jmsLock, JmsSessionManager sessionManager, SourceCallback<Object, T> sourceCallback, JmsSpecification specification, InternalAckMode ackMode, String encoding, String contentType, ConnectionProvider<JmsTransactionalConnection> connectionProvider, JmsConnectionExceptionResolver exceptionResolver) {
        this.session = session;
        this.sourceCallback = sourceCallback;
        this.jmsLock = jmsLock;
        this.ackMode = ackMode;
        this.sessionManager = sessionManager;
        this.connectionProvider = connectionProvider;
        this.exceptionResolver = exceptionResolver;
        this.messageDispacher = new JmsMessageDispatcher(config, contentType, encoding, specification, session, ackMode, sessionManager, sourceCallback, jmsLock, exceptionResolver);
    }

    public void onMessage(Message message) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Received message on session: " + this.session.get().toString());
        }
        SourceCallbackContext context = this.sourceCallback.createContext();
        try {
            context.bindConnection(this.connectionProvider.connect());
        }
        catch (ConnectionException | TransactionException e) {
            JmsListener.notifyIfConnectionProblem(this.sourceCallback, (Exception)e, this.exceptionResolver);
        }
        if (this.ackMode.equals((Object)InternalAckMode.TRANSACTED)) {
            this.sessionManager.bindToTransaction(this.session);
        }
        this.jmsLock.init();
        context.addVariable("JMS_LOCK", (Object)this.jmsLock);
        this.messageDispacher.dispatchMessage(message, context);
        try {
            this.waitForMessageToBeProcessed(this.jmsLock);
        }
        catch (Exception e) {
            try {
                this.session.get().recover();
            }
            catch (JMSException jmsException) {
                LOGGER.warn("An error occurred trying to recover the session because of a failure message processing.", (Throwable)jmsException);
            }
        }
    }

    private void waitForMessageToBeProcessed(JmsListenerLock jmsLock) {
        jmsLock.lock();
    }
}

