/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.connection.session;

import javax.jms.JMSException;

/**
 * Callback for Acknowledge related tasks
 * @since 1.0
 */
public interface AckCallback {

  /**
   * Callback for success processing
   */
  void onSuccess();

  /**
   * Callback for erroneous processing
   */
  void onError(JMSException e);
}
