/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.source;

import static java.lang.String.format;
import static org.slf4j.LoggerFactory.getLogger;

import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.source.push.MessageListenerContext;

import javax.jms.Connection;
import javax.jms.JMSException;

import org.slf4j.Logger;

/**
 * A default JmsResourceReleaser implementation in which the cleanup is performed in a silent way.
 */
public class DefaultJmsResourceReleaser implements JmsResourceReleaser {

  private final Logger LOGGER = getLogger(this.getClass());

  @Override
  public final void releaseConnection(Connection connection) {
    try {
      doCleanConnection(connection);
    } catch (Exception e) {
      LOGGER.warn(format("An exception was raised when cleaning the JMS Connection [%s]:", connection.getClass().getName()), e);
    }
  }

  @Override
  public void releaseConsumerMessageListener(MessageListenerContext info) {
    JmsCommons.closeQuietly(info.getConsumer());
  }

  protected void doCleanConnection(Connection connection) {
    // Do nothing.
  }
}
