/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.source.push;

import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.consume.JmsMessageConsumer;
import org.mule.jms.commons.internal.source.JmsListenerLock;

/**
 * Container used to describe a {@link javax.jms.MessageConsumer} and its related resources.
 */
public class MessageListenerContext {

  private final JmsMessageListener messageListener;
  private JmsSession session;
  private JmsListenerLock jmsListenerLock;
  private JmsMessageConsumer messageConsumer;

  MessageListenerContext(JmsSession session, JmsListenerLock jmsListenerLock, JmsMessageConsumer messageConsumer,
                         JmsMessageListener listener) {
    this.session = session;
    this.jmsListenerLock = jmsListenerLock;
    this.messageConsumer = messageConsumer;
    this.messageListener = listener;
  }

  public JmsSession getSession() {
    return session;
  }

  public JmsListenerLock getLock() {
    return jmsListenerLock;
  }

  public JmsMessageConsumer getConsumer() {
    return messageConsumer;
  }

  public JmsMessageListener getListener() {
    return messageListener;
  }
}
