/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.connection;

import static org.slf4j.LoggerFactory.getLogger;

import java.util.concurrent.atomic.AtomicReference;

import javax.transaction.xa.XAResource;

import org.slf4j.Logger;

/**
 * Wrapper for an {@link XAResource} which makes it compatible with XA Transactions in Mule 4.
 *
 * @since 1.4.0
 */
public class JmsXaContext {

  private static final Logger LOGGER = getLogger(JmsXaContext.class);

  private final XAResource xaResource;
  private final AtomicReference<Runnable> runnableRef = new AtomicReference<>();

  public JmsXaContext(XAResource xaResource) {
    this.xaResource = xaResource;
  }

  public XAResource getXaResource() {
    return xaResource;
  }

  public void end() {
    LOGGER.debug("{} # end()", this);
    final Runnable runnable = runnableRef.get();
    if (runnable != null) {
      runnable.run();
    }
  }

  public void afterEnds(Runnable runnable) {
    this.runnableRef.set(runnable);
  }

  @Override
  public String toString() {
    return "JmsXaContext{xaResource: " + xaResource.toString() + "}@" + Integer.toHexString(hashCode());
  }
}
