/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.connection.provider;

import org.mule.jms.commons.internal.connection.param.GenericConnectionParameters;
import org.mule.jms.commons.internal.connection.param.XaPoolParameters;

import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;

/**
 * JMS {@link ConnectionFactory} contract
 *
 * @since 1.4.0
 */
public interface ConnectionFactoryDecorator {

  /**
   * Decorates a Connection Factory with the available Connection Factory Decorators on the Mule Runtime.
   *
   * @param connectionFactory Connection Factory to decorate
   * @param configName Global Element name of the JMS Configuration
   * @param reuseSessions If the sessions should be reused
   * @param connectionParameters the connection parameters
   * @param xaPoolParameters the XA pool configuration
   * @param exceptionListener ExceptionListener of the JMS Connection
   * @return A possible decorated ConnectionFactory, the same will be returned in case of no decorator found.
   */
  ConnectionFactory decorate(ConnectionFactory connectionFactory,
                             String configName,
                             boolean reuseSessions,
                             GenericConnectionParameters connectionParameters,
                             XaPoolParameters xaPoolParameters,
                             ExceptionListener exceptionListener);
}
