/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.source;

import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.extension.api.tx.SourceTransactionalAction;

/**
 * Group of parameters of the configuration of a Message Source
 *
 * @since 1.1.0
 */
public class SourceConfiguration {

  private SourceTransactionalAction transactionalAction;
  private TransactionType transactionType;
  private ComponentLocation componentLocation;
  private String configName;

  public SourceConfiguration(SourceTransactionalAction transactionalAction, TransactionType transactionType,
                             ComponentLocation componentLocation, String configName) {
    this.transactionalAction = transactionalAction;
    this.transactionType = transactionType;
    this.componentLocation = componentLocation;
    this.configName = configName;
  }

  /**
   * @return The flow where the source is located
   */
  public String getFlowName() {
    return componentLocation.getRootContainerName();
  }

  /**
   * @return The transactional action that the source will perform when dispatched a message
   */
  public SourceTransactionalAction getTransactionalAction() {
    return transactionalAction;
  }

  /**
   * @return The type of transaction to start.
   */
  public TransactionType getTransactionType() {
    return transactionType;
  }

  /**
   * @return The config used by the message source
   */
  public String getConfigName() {
    return configName;
  }
}
