/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.operation;

import java.util.concurrent.TimeUnit;
import javax.jms.CompletionListener;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.JMSSecurityException;
import javax.jms.Message;
import org.mule.jms.commons.api.config.JmsConsumerConfig;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.api.exception.JmsConsumeErrorTypeProvider;
import org.mule.jms.commons.api.exception.JmsConsumeException;
import org.mule.jms.commons.api.exception.JmsExtensionException;
import org.mule.jms.commons.api.exception.JmsSecurityException;
import org.mule.jms.commons.api.message.JmsAttributes;
import org.mule.jms.commons.internal.common.JmsCommons;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.config.JmsAckMode;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.session.JmsMessageAckedMonitor;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.consume.JmsMessageConsumer;
import org.mule.jms.commons.internal.message.JmsResultFactory;
import org.mule.jms.commons.internal.metadata.JmsOutputResolver;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.tx.OperationTransactionalAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsConsume
implements Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsConsume.class);
    private static final long CONSUMER_RESOURCE_RELEASE_TIMEOUT_MILLISECONDS = 20000L;
    private final JmsResultFactory resultFactory = JmsResultFactory.getInstance();
    private JmsSessionManager sessionManager;

    public JmsConsume(JmsSessionManager sessionManager, SchedulerService schedulerService) {
        this.sessionManager = sessionManager;
    }

    @OutputResolver(output=JmsOutputResolver.class)
    @Throws(value={JmsConsumeErrorTypeProvider.class})
    public void consume(final @Config JmsConfig config, @Connection JmsTransactionalConnection connection, final @Summary(value="The name of the Destination from where the Message should be consumed") String destination, final @ConfigOverride @Summary(value="The Type of the Consumer that should be used for the provided destination") ConsumerType consumerType, @Optional @Summary(value="The Session ACK mode to use when consuming a message") JmsAckMode ackMode, @ConfigOverride @Summary(value="The JMS selector to be used for filtering incoming messages") String selector, final @Optional @Summary(value="The content type of the message body") @Example(value="application/json") String contentType, final @Optional @Summary(value="The encoding of the message body") @Example(value="UTF-8") String encoding, @Optional(defaultValue="10000") @Summary(value="Maximum time to wait for a message to arrive before timeout") Long maximumWait, @Optional(defaultValue="MILLISECONDS") @Example(value="MILLISECONDS") @Summary(value="Time unit to be used in the maximumWaitTime configuration") TimeUnit maximumWaitUnit, OperationTransactionalAction transactionalAction, final CompletionCallback<Object, JmsAttributes> completionCallback) throws JmsExtensionException {
        final InternalAckMode resolvedAckMode = this.resolveAck((JmsConsumerConfig)config.getConsumerConfig(), ackMode);
        JmsSession session = null;
        boolean partOfCurrentTx = false;
        JmsMessageConsumer consumer = null;
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Begin [consume] on the " + JmsCommons.getDestinationType(consumerType) + ": [" + destination + "]");
            }
            final JmsSupport jmsSupport = connection.getJmsSupport();
            session = JmsCommons.createJmsSession(connection, resolvedAckMode, consumerType.topic(), this.sessionManager, transactionalAction);
            partOfCurrentTx = JmsCommons.isPartOfCurrentTx(session, connection, this.sessionManager);
            Destination jmsDestination = jmsSupport.createDestination(session.get(), destination, consumerType.topic(), config);
            consumer = connection.createConsumer(session, jmsDestination, selector, consumerType);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Consuming Message from the " + JmsCommons.getDestinationType(consumerType) + ": [" + destination + "]");
            }
            final JmsMessageConsumer finalConsumer = consumer;
            final JmsSession finalSession = session;
            final boolean finalPartOfCurrentTx = partOfCurrentTx;
            consumer.consume(maximumWaitUnit.toMillis(maximumWait), config.getResourceReleaserScheduler(), new CompletionListener(){
                final JmsMessageAckedMonitor jmsMessageAckedMonitor = new JmsMessageAckedMonitor();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onCompletion(Message received) {
                    block11: {
                        try {
                            if (received == null) {
                                completionCallback.success(JmsConsume.this.resultFactory.createEmptyResult());
                                break block11;
                            }
                            String resolvedContentType = JmsCommons.resolveOverride(JmsCommons.resolveMessageContentType(received, config.getContentType()), contentType);
                            String resolvedEncoding = JmsCommons.resolveOverride(JmsCommons.resolveMessageEncoding(received, config.getEncoding()), encoding);
                            Result result = JmsConsume.this.resultFactory.createResult(received, jmsSupport.getSpecification(), resolvedContentType, resolvedEncoding, finalSession.getAckId());
                            JmsCommons.evaluateMessageAck(resolvedAckMode, finalSession, received, JmsConsume.this.sessionManager, null, this.jmsMessageAckedMonitor);
                            completionCallback.success(result);
                        }
                        catch (Exception e) {
                            try {
                                String msg = String.format("An error occurred while consuming a message from the %s [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
                                completionCallback.error((Throwable)((Object)new JmsConsumeException(msg, e)));
                            }
                            catch (Throwable throwable) {
                                if (JmsCommons.isManualAck(finalSession) && JmsConsume.this.sessionManager.isPendingAck(finalSession.getAckId().get())) {
                                    config.getResourceReleaserScheduler().execute(() -> {
                                        this.jmsMessageAckedMonitor.waitForMessageAcked();
                                        JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                                    });
                                } else {
                                    JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                                }
                                throw throwable;
                            }
                            if (JmsCommons.isManualAck(finalSession) && JmsConsume.this.sessionManager.isPendingAck(finalSession.getAckId().get())) {
                                config.getResourceReleaserScheduler().execute(() -> {
                                    this.jmsMessageAckedMonitor.waitForMessageAcked();
                                    JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                                });
                            } else {
                                JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                            }
                        }
                    }
                    if (JmsCommons.isManualAck(finalSession) && JmsConsume.this.sessionManager.isPendingAck(finalSession.getAckId().get())) {
                        config.getResourceReleaserScheduler().execute(() -> {
                            this.jmsMessageAckedMonitor.waitForMessageAcked();
                            JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                        });
                    } else {
                        JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                    }
                }

                public void onException(Message message, Exception e) {
                    JmsCommons.releaseResources(finalSession, finalPartOfCurrentTx, finalConsumer);
                    if (e instanceof JMSSecurityException) {
                        String msg = String.format("A security error occurred while consuming a message from the %s: [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
                        completionCallback.error((Throwable)((Object)new JmsSecurityException(msg, e)));
                    } else if (e instanceof JmsConsumeException) {
                        completionCallback.error((Throwable)e);
                    } else {
                        String msg = String.format("An error occurred while consuming a message from the %s [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
                        completionCallback.error((Throwable)((Object)new JmsConsumeException(msg, e)));
                    }
                }
            });
        }
        catch (JMSSecurityException e) {
            String msg = String.format("A security error occurred while consuming a message from the %s: [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
            JmsCommons.releaseResources(session, partOfCurrentTx, consumer);
            completionCallback.error((Throwable)((Object)new JmsSecurityException(msg, (Exception)((Object)e))));
        }
        catch (IllegalStateException e) {
            boolean isConnectionError = session == null;
            String msg = String.format((isConnectionError ? "A connection error" : "An error") + " occurred while consuming a message from the %s: [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
            completionCallback.error((Throwable)(isConnectionError ? new ConnectionException((Throwable)e) : new JmsConsumeException(msg, (Exception)((Object)e))));
            JmsCommons.releaseResources(session, partOfCurrentTx, consumer);
        }
        catch (Exception e) {
            String msg = String.format("An error occurred while consuming a message from the %s [%s]: %s", JmsCommons.getDestinationType(consumerType), destination, e.getMessage());
            JmsCommons.releaseResources(session, partOfCurrentTx, consumer);
            completionCallback.error((Throwable)((Object)new JmsConsumeException(msg, e)));
        }
    }

    private InternalAckMode resolveAck(JmsConsumerConfig config, JmsAckMode ackMode) {
        InternalAckMode fallbackAck = JmsCommons.toInternalAckMode(config.getAckMode());
        if (InternalAckMode.AUTO.equals((Object)fallbackAck) || InternalAckMode.DUPS_OK.equals((Object)fallbackAck)) {
            fallbackAck = InternalAckMode.IMMEDIATE;
        }
        return JmsCommons.resolveOverride(fallbackAck, JmsCommons.toInternalAckMode(ackMode));
    }

    public void dispose() {
    }
}

