/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.operation.publishconsume;

import static org.mule.jms.commons.internal.common.JmsCommons.closeQuietly;

import javax.jms.Message;

import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.jms.commons.internal.publish.JmsMessageProducer;
import org.mule.runtime.api.scheduler.Scheduler;

/**
 * Closes the producer resources scheduling a task
 *
 * @since 1.12.0
 */
public class ProducerResourceCloserAction {

  private JmsSession producerSession;
  private AutoCloseable producer;
  private final Scheduler scheduler;


  public ProducerResourceCloserAction(JmsSession jmsSession,
                                      JmsMessageProducer producer,
                                      Scheduler scheduler) {
    this.producerSession = jmsSession;
    this.producer = producer;
    this.scheduler = scheduler;
  }


  public void closeResources() {
    scheduler.submit(this.doCloseResources());
  }


  private Runnable doCloseResources() {
    return () -> {
      closeQuietly(producer);
      closeQuietly(producerSession);
    };
  }
}
