/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.api.connection.caching;

import java.util.Objects;
import java.util.Optional;
import javax.jms.ConnectionFactory;
import javax.jms.XAConnectionFactory;
import org.mule.jms.commons.api.connection.caching.CachingConfiguration;
import org.mule.jms.commons.api.connection.caching.CachingStrategy;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.springframework.jms.connection.CachingConnectionFactory;

@Alias(value="default-caching")
public class DefaultCachingStrategy
implements CachingStrategy,
CachingConfiguration {
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    int sessionCacheSize = Integer.MAX_VALUE;
    @Parameter
    @Alias(value="cacheProducers")
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    boolean producersCache;
    @Parameter
    @Alias(value="cacheConsumers")
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="true")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    boolean consumersCache;

    @Override
    public int getSessionCacheSize() {
        return this.sessionCacheSize;
    }

    @Override
    public boolean isProducersCache() {
        return this.producersCache;
    }

    @Override
    public boolean isConsumersCache() {
        return this.consumersCache;
    }

    @Override
    public boolean appliesTo(ConnectionFactory target) {
        return !(target instanceof XAConnectionFactory) && !(target instanceof CachingConnectionFactory);
    }

    @Override
    public Optional<CachingConfiguration> strategyConfiguration() {
        return Optional.of(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCachingStrategy that = (DefaultCachingStrategy)o;
        return this.sessionCacheSize == that.sessionCacheSize && this.producersCache == that.producersCache && this.consumersCache == that.consumersCache;
    }

    public int hashCode() {
        return Objects.hash(this.sessionCacheSize, this.producersCache, this.consumersCache);
    }
}

