/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.consume;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.jms.CompletionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import org.apache.commons.lang3.time.StopWatch;
import org.mule.jms.commons.api.exception.JmsConsumeException;
import org.mule.jms.commons.api.exception.JmsTimeoutException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmsMessageConsumer
implements AutoCloseable {
    private static final Double DELTA = 0.01;
    private static final Logger LOGGER = LoggerFactory.getLogger(JmsMessageConsumer.class);
    private final MessageConsumer consumer;

    public JmsMessageConsumer(MessageConsumer consumer) {
        Preconditions.checkArgument((consumer != null ? 1 : 0) != 0, (String)"A non null MessageConsumer is required to use as delegate");
        this.consumer = consumer;
    }

    public void listen(MessageListener listener) throws JMSException {
        this.consumer.setMessageListener(listener);
    }

    public Message consume(Long maximumWaitTime) throws JMSException, JmsTimeoutException {
        if (maximumWaitTime == -1L) {
            return this.receive();
        }
        if (maximumWaitTime == 0L) {
            return this.receiveNoWait();
        }
        return this.receiveWithTimeout(maximumWaitTime);
    }

    public void consume(Long maximumWaitTime, CompletionListener completionListener) {
        try {
            if (maximumWaitTime == 0L) {
                completionListener.onCompletion(this.consumer.receiveNoWait());
            } else if (maximumWaitTime == -1L) {
                completionListener.onCompletion(this.consumer.receive());
            } else {
                completionListener.onCompletion(this.receiveWithTimeout(maximumWaitTime));
            }
        }
        catch (Exception e) {
            completionListener.onException(null, e);
        }
    }

    @Override
    public void close() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing consumer " + this.consumer);
        }
        this.consumer.close();
    }

    private Long calculateThreshold(Long timeout) {
        return (double)timeout.longValue() * DELTA < 1000.0 ? (long)((double)timeout.longValue() * DELTA) : 1000L;
    }

    private Message receiveWithTimeout(Long maximumWaitTime) throws JMSException, JmsTimeoutException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Waiting for a message, timeout will be in [%s] millis", maximumWaitTime));
        }
        StopWatch timeoutValidator = new StopWatch();
        timeoutValidator.start();
        Message message = this.consumer.receive(maximumWaitTime.longValue());
        timeoutValidator.stop();
        Long threshold = this.calculateThreshold(maximumWaitTime);
        if (message == null && timeoutValidator.getTime() >= maximumWaitTime - threshold) {
            throw new JmsTimeoutException(String.format("Failed to retrieve a Message. Operation timed out after %s milliseconds", maximumWaitTime));
        }
        return message;
    }

    private Message receiveNoWait() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Trying to consume an immediately available message");
        }
        return this.consumer.receiveNoWait();
    }

    private Message receive() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("No Timeout set, waiting for a message until one arrives");
        }
        return this.consumer.receive();
    }

    public MessageConsumer get() {
        return this.consumer;
    }

    public void consume(Long maximumWaitTime, Scheduler scheduler, CompletionListener completionListener) {
        CompletableFuture completableFuture = new CompletableFuture();
        try {
            this.consumer.setMessageListener(completableFuture::complete);
            scheduler.execute(() -> {
                try {
                    Message message = maximumWaitTime > 0L ? (Message)completableFuture.get(maximumWaitTime, TimeUnit.MILLISECONDS) : (maximumWaitTime == 0L ? (Message)completableFuture.getNow(null) : (Message)completableFuture.get());
                    completionListener.onCompletion(message);
                }
                catch (ExecutionException e) {
                    completionListener.onException(null, (Exception)((Object)new JmsConsumeException("Unable to listen for message.", e)));
                }
                catch (TimeoutException e) {
                    completionListener.onException(null, (Exception)((Object)new JmsTimeoutException(String.format("Failed to retrieve a Message. Operation timed out after %s milliseconds", maximumWaitTime))));
                }
                catch (InterruptedException e) {
                    completionListener.onException(null, (Exception)new JMSException("Unable to listen for message.", e.getMessage()));
                }
            });
        }
        catch (Exception e) {
            completionListener.onException(null, e);
        }
    }
}

