/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.support;

import java.util.Optional;
import java.util.function.Function;
import javax.jms.CompletionListener;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.Topic;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XASession;
import org.apache.commons.lang3.StringUtils;
import org.mule.jms.commons.api.connection.JmsSpecification;
import org.mule.jms.commons.api.connection.LookupJndiDestination;
import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.api.destination.TopicConsumer;
import org.mule.jms.commons.api.exception.DestinationNotFoundException;
import org.mule.jms.commons.internal.config.JmsConfig;
import org.mule.jms.commons.internal.support.JmsSupport;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jms20Support
implements JmsSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(Jms20Support.class);
    private final Function<String, Optional<Destination>> jndiObjectSupplier;
    private final LookupJndiDestination lookupJndiDestination;

    public Jms20Support() {
        this(LookupJndiDestination.NEVER, name -> Optional.empty());
    }

    public Jms20Support(LookupJndiDestination lookupJndiDestination, Function<String, Optional<Destination>> jndiObjectSupplier) {
        Preconditions.checkArgument((lookupJndiDestination != null ? 1 : 0) != 0, (String)"The LookupJndiDestination cannot be null");
        Preconditions.checkArgument((jndiObjectSupplier != null ? 1 : 0) != 0, (String)"The JndiObjectSupplier cannot be null");
        this.lookupJndiDestination = lookupJndiDestination;
        this.jndiObjectSupplier = jndiObjectSupplier;
    }

    @Override
    public JmsSpecification getSpecification() {
        return JmsSpecification.JMS_2_0;
    }

    @Override
    public Connection createConnection(ConnectionFactory connectionFactory, String username, String password) throws JMSException {
        Preconditions.checkArgument((connectionFactory != null ? 1 : 0) != 0, (String)"connectionFactory cannot be null");
        LOGGER.trace("Creating Connection with username and password");
        return connectionFactory.createConnection(username, password);
    }

    @Override
    public XAConnection createXaConnection(XAConnectionFactory connectionFactory) throws JMSException {
        Preconditions.checkArgument((connectionFactory != null ? 1 : 0) != 0, (String)"connectionFactory cannot be null");
        LOGGER.trace("Creating XaConnection");
        return connectionFactory.createXAConnection();
    }

    @Override
    public XAConnection createXaConnection(XAConnectionFactory connectionFactory, String username, String password) throws JMSException {
        Preconditions.checkArgument((connectionFactory != null ? 1 : 0) != 0, (String)"connectionFactory cannot be null");
        LOGGER.trace("Creating XaConnection with UserName and Password");
        return connectionFactory.createXAConnection(username, password);
    }

    @Override
    public Connection createConnection(ConnectionFactory connectionFactory) throws JMSException {
        if (connectionFactory == null) {
            throw new IllegalArgumentException("connectionFactory cannot be null");
        }
        LOGGER.trace("Creating connection");
        return connectionFactory.createConnection();
    }

    @Override
    public Session createSession(Connection connection, boolean topic, boolean transacted, int ackMode) throws JMSException {
        LOGGER.trace("Creating session. Topic [{}],Transacted [{}], AckMode [{}]", new Object[]{topic, transacted, ackMode});
        return connection.createSession(transacted, transacted ? 0 : ackMode);
    }

    @Override
    public XASession createXaSession(XAConnection connection) throws JMSException {
        Preconditions.checkArgument((connection != null ? 1 : 0) != 0, (String)"XA Connection cannot be null");
        LOGGER.trace("Creating XA Session");
        return connection.createXASession();
    }

    @Override
    public MessageProducer createProducer(Session session, Destination destination, boolean topic) throws JMSException {
        LOGGER.trace("Creating producer for destination [{}].Is Topic: [{}].", (Object)destination, (Object)topic);
        return session.createProducer(destination);
    }

    @Override
    public MessageConsumer createConsumer(Session session, Destination destination, String messageSelector, ConsumerType type) throws JMSException {
        if (!type.topic()) {
            LOGGER.trace("Creating Queue Consumer for [{}] with selector [{}]", (Object)destination, (Object)messageSelector);
            return session.createConsumer(destination, messageSelector);
        }
        TopicConsumer topicConsumer = (TopicConsumer)type;
        if (topicConsumer.isDurable() && topicConsumer.isShared()) {
            LOGGER.trace("Creating Shared Durable Topic Consumer for [{}] with Subscription Name [{}] and Message Selector [{}]", new Object[]{destination, topicConsumer.getSubscriptionName(), messageSelector});
            return session.createSharedDurableConsumer((Topic)destination, topicConsumer.getSubscriptionName(), messageSelector);
        }
        if (topicConsumer.isDurable()) {
            LOGGER.trace("Creating Durable Topic Subscriber for [{}] with SubscriptionName [{}] and Message Selector [{}]. Is No Local: [{}]", new Object[]{destination, topicConsumer.getSubscriptionName(), messageSelector, topicConsumer.isNoLocal()});
            return session.createDurableSubscriber((Topic)destination, topicConsumer.getSubscriptionName(), messageSelector, topicConsumer.isNoLocal());
        }
        if (topicConsumer.isShared()) {
            LOGGER.trace("Creating Shared Topic Consumer for [{}] with SubscriptionName [{}] and Message Selector [{}]", new Object[]{destination, topicConsumer.getSubscriptionName(), messageSelector});
            return session.createSharedConsumer((Topic)destination, topicConsumer.getSubscriptionName(), messageSelector);
        }
        LOGGER.trace("Creating consumer for Topic [{}] with Message Selector [{}]. Is No Local: [{}]", new Object[]{destination, messageSelector, topicConsumer.isNoLocal()});
        return session.createConsumer(destination, messageSelector, topicConsumer.isNoLocal());
    }

    @Override
    public Destination createDestination(Session session, String name, boolean topic, JmsConfig config) throws JMSException, DestinationNotFoundException {
        Topic destination;
        if (this.getLookupJndiDestination().equals((Object)LookupJndiDestination.ALWAYS) || this.getLookupJndiDestination().equals((Object)LookupJndiDestination.TRY_ALWAYS)) {
            destination = this.createDestinationFromJndi(name);
            if (destination.isPresent()) {
                return destination.get();
            }
            if (this.getLookupJndiDestination().equals((Object)LookupJndiDestination.ALWAYS)) {
                LOGGER.debug("Failed to find JNDI destination [{}], but destination origin was forced as ALWAYS use JNDI. We have to stop execution.", (Object)name);
                throw new DestinationNotFoundException("Failed to find JNDI destination [" + name + "]");
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using non-JNDI destination [{}], will create one now", (Object)name);
        }
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (String)"Session cannot be null when creating a destination");
        Preconditions.checkArgument((!StringUtils.isBlank((CharSequence)name) ? 1 : 0) != 0, (String)"Destination name cannot be blank when creating a destination");
        if (topic) {
            LOGGER.debug("Creating Topic Destination with name: [{}]", (Object)name);
            destination = session.createTopic(name);
        } else {
            LOGGER.debug("Creating Queue Destination with name: [{}]", (Object)name);
            destination = session.createQueue(name);
        }
        return destination;
    }

    protected Optional<Destination> createDestinationFromJndi(String name) throws JMSException {
        Optional<Destination> dest = this.getJndiDestination(name);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Destination [{}] {}", (Object)name, (Object)(dest.isPresent() ? "located in JNDI, will use it now" : "not found using JNDI"));
        }
        return dest;
    }

    protected Optional<Destination> getJndiDestination(String name) {
        try {
            LOGGER.debug("Looking up {} from JNDI", (Object)name);
            return this.getJndiObjectSupplier().apply(name);
        }
        catch (Exception e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to look up destination [{}]: ", (Object)name, (Object)e);
            }
            return Optional.empty();
        }
    }

    @Override
    public TemporaryQueue createTemporaryDestination(Session session) throws JMSException {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (String)"Session cannot be null when creating a destination");
        LOGGER.debug("Creating temporary destination");
        return session.createTemporaryQueue();
    }

    @Override
    public void send(MessageProducer producer, Message message, boolean persistent, int priority, long ttl, boolean topic) throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            Destination dest = producer.getDestination();
            LOGGER.debug("Sending message to [{}], persistent:[{}], with priority:[{}] and ttl:[{}]", new Object[]{dest instanceof Queue ? ((Queue)dest).getQueueName() : ((Topic)dest).getTopicName(), persistent, priority, ttl});
        }
        producer.send(message, persistent ? 2 : 1, priority, ttl);
    }

    @Override
    public void send(MessageProducer producer, Message message, boolean persistent, int priority, long ttl, boolean topic, CompletionListener completionListener) throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            Destination dest = producer.getDestination();
            LOGGER.debug("Sending message to [{}], persistent:[{}], with priority:[{}] and ttl:[{}]", new Object[]{dest instanceof Queue ? ((Queue)dest).getQueueName() : ((Topic)dest).getTopicName(), persistent, priority, ttl});
        }
        producer.send(message, persistent ? 2 : 1, priority, ttl, completionListener);
    }

    private Function<String, Optional<Destination>> getJndiObjectSupplier() {
        return this.jndiObjectSupplier;
    }

    protected LookupJndiDestination getLookupJndiDestination() {
        return this.lookupJndiDestination;
    }
}

