/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.message;

import java.util.Map;
import org.mule.jms.commons.api.message.DefaultJmsAttributes;
import org.mule.jms.commons.api.message.JmsAttributes;
import org.mule.jms.commons.api.message.JmsHeaders;
import org.mule.jms.commons.api.message.JmsMessageProperties;
import org.mule.jms.commons.internal.message.JmsAttributesBuilder;
import org.mule.runtime.api.util.Preconditions;

public class DefaultJmsAttributesBuilder
implements JmsAttributesBuilder {
    private JmsMessageProperties properties;
    private JmsHeaders headers;
    private String ackId;

    @Override
    public DefaultJmsAttributesBuilder withProperties(Map<String, Object> properties) {
        this.properties = new JmsMessageProperties(properties);
        return this;
    }

    @Override
    public DefaultJmsAttributesBuilder withHeaders(JmsHeaders headers) {
        this.headers = headers;
        return this;
    }

    @Override
    public DefaultJmsAttributesBuilder withAckId(String ackId) {
        this.ackId = ackId;
        return this;
    }

    @Override
    public JmsAttributes build() {
        Preconditions.checkArgument((this.properties != null ? 1 : 0) != 0, (String)"No JmsMessageProperties were provided, but they are required for the JmsAttributes");
        Preconditions.checkArgument((this.headers != null ? 1 : 0) != 0, (String)"No JmsHeaders were provided, but they are required for the JmsAttributes");
        return new DefaultJmsAttributes(this.properties, this.headers, this.ackId);
    }
}

