/*
 * Decompiled with CFR 0.152.
 */
package org.mule.jms.commons.internal.connection.session;

import java.util.Optional;
import javax.jms.JMSException;
import javax.jms.Session;
import org.mule.jms.commons.internal.connection.session.JmsSession;
import org.mule.runtime.api.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJmsSession
implements JmsSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJmsSession.class);
    private final Session session;
    private String ackId;

    public DefaultJmsSession(Session session) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (String)"A non null Session is required to use as delegate");
        this.session = session;
    }

    public DefaultJmsSession(Session session, String ackId) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (String)"A non null Session is required to use as delegate");
        this.session = session;
        this.ackId = ackId;
    }

    @Override
    public Session get() {
        return this.session;
    }

    @Override
    public Optional<String> getAckId() {
        return Optional.ofNullable(this.ackId);
    }

    @Override
    public void close() throws JMSException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Closing session " + this.session);
        }
        this.session.close();
    }
}

