/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.api;

import javax.jms.JMSException;
import javax.jms.Message;

public interface RequestReplyPatternWrapper {

  /**
   * Creates the selector for request reply and adds custom logic in case it is necessary.
   * 
   * @param requestReplyPattern the pattern (CORRELATION_ID, MESSAGE_ID, NONE)
   * @param message             the message to apply the request reply operation
   * 
   * @return the string representing the request reply selector
   * 
   * @throws JMSException exception during the creation of the selector
   */
  String createSelector(RequestReplyPattern requestReplyPattern, Message message) throws JMSException;

}
