/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.publish;

import java.util.Arrays;
import java.util.List;

public class PublishConnectionExceptionErrorCodes {

  private static final String IBM_OPEN_QUEUE_FAILED = "JMSWMQ2008";
  private static final String IBM_PUBLISH_QUEUE_FAILED = "JMSCC0005";
  private static final String IBM_CHANNEL_CLOSED_CODE = "JMSWMQ0018";

  public static final List<String> DETAILED_JMS_EXCEPTION_CODES =
      Arrays.asList(IBM_OPEN_QUEUE_FAILED, IBM_PUBLISH_QUEUE_FAILED, IBM_CHANNEL_CLOSED_CODE);
}
