/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.source;

import static org.mule.runtime.core.api.util.ExceptionUtils.extractConnectionException;
import org.mule.runtime.api.connection.ConnectionException;

import java.util.Optional;

/**
 * Delegates to the default {@link org.mule.runtime.core.api.util.ExceptionUtils implementation}.
 *
 * @Since 1.1.8
 */
public class DefaultJmsConnectionExceptionResolver implements JmsConnectionExceptionResolver {

  @Override
  public Optional<ConnectionException> resolveException(Throwable e) {
    return extractConnectionException(e);
  }
}
