/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.connection.session;

import org.slf4j.Logger;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

import static org.slf4j.LoggerFactory.getLogger;
import static java.util.concurrent.TimeUnit.MILLISECONDS;

public class JmsMessageAckedMonitor {

  private static final Logger LOGGER = getLogger(JmsMessageAckedMonitor.class);
  private static final long CONSUMER_RESOURCE_RELEASE_TIMEOUT_MILLISECONDS = 20000;


  final Lock messageAckedLock;
  final Condition messageAckedCondition;
  boolean messageAcked = false;

  public JmsMessageAckedMonitor() {
    messageAckedLock = new ReentrantLock();
    messageAckedCondition = messageAckedLock.newCondition();
  }

  public void notifyMessageAcked() {
    messageAckedLock.lock();
    try {
      messageAcked = true;
      if (messageAckedCondition != null) {
        messageAckedCondition.signal();
      }
    } finally {
      messageAckedLock.unlock();
    }
  }

  public void waitForMessageAcked() {
    messageAckedLock.lock();

    try {
      while (!messageAcked) {
        messageAckedCondition.await(CONSUMER_RESOURCE_RELEASE_TIMEOUT_MILLISECONDS, MILLISECONDS);
      }
    } catch (InterruptedException e) {
      LOGGER.error(e.getMessage());
    } finally {
      messageAckedLock.unlock();
    }
  }


}
