/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.message;

import org.mule.jms.commons.api.message.JmsAttributes;
import org.mule.jms.commons.api.message.JmsHeaders;
import org.mule.jms.commons.api.message.JmsHeadersBuilder;

import java.util.Map;

/**
 * {@link JmsAttributesBuilder} contract
 *
 * @since 1.0.1
 */
public interface JmsAttributesBuilder {

  JmsAttributesBuilder withProperties(Map<String, Object> properties);

  JmsAttributesBuilder withHeaders(JmsHeaders headers);

  JmsAttributesBuilder withAckId(String ackId);

  JmsAttributes build();
}
