/*
 * Copyright © MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.source;

import org.mule.runtime.api.connection.ConnectionException;

import java.util.Optional;

/**
 * Let each JmsListener specific implementation resolve which exception raised by the custom client (from now on, the
 * <b>client</b>) is considered as a {@link ConnectionException connection exception}, which might lead to reconnection logic
 * execution.
 *
 * @Since 1.1.8
 */
public interface JmsConnectionExceptionResolver {

  /**
   * Decide whether the exception thrown by the client should be considered as a {@link ConnectionException connection exception}
   *
   * @param e The exception thrown by the third-party JMS client.
   * @return An optional that might contain, if it's the case, a {@link ConnectionException connection exception}
   */
  Optional<ConnectionException> resolveException(Throwable e);

}
