/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.api.exception;

import static java.util.Collections.unmodifiableSet;
import static org.mule.jms.commons.api.exception.JmsError.ACK;
import org.mule.jms.commons.internal.operation.JmsAcknowledge;
import org.mule.runtime.extension.api.annotation.error.ErrorTypeProvider;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;

import java.util.HashSet;
import java.util.Set;

/**
 * Errors that can be thrown in the {@link JmsAcknowledge#ack(String)} operation.
 *
 * @since 1.0
 */
public class JmsAckErrorTypeProvider implements ErrorTypeProvider {

  @Override
  public Set<ErrorTypeDefinition> getErrorTypes() {
    Set<ErrorTypeDefinition> tmpSet = new HashSet<>();
    tmpSet.add(ACK);
    return unmodifiableSet(tmpSet);
  }
}

