/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.internal.common;

import org.slf4j.Logger;

import static org.slf4j.LoggerFactory.getLogger;

public final class IBMClientCommons {

  private static final Logger LOGGER = getLogger(IBMClientCommons.class);

  public static boolean isConnectionBrokenException(Throwable throwable) {
    if (throwable == null)
      return false;

    for (throwable = throwable.getCause(); throwable != null; throwable = throwable.getCause()) {
      if (throwable.getClass().getName().startsWith("com.ibm") && throwable.getCause().toString().contains("2009")) {
        LOGGER.error("Caught IBM connection broken exception");
        return true;
      }
    }
    return false;
  }
}
