/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.jms.commons.api.config;

import org.mule.jms.commons.api.destination.ConsumerType;
import org.mule.jms.commons.internal.config.JmsAckMode;

public interface JmsConsumerConfig<C extends ConsumerType> {

  public int getMaxRedelivery();

  public String getSelector();

  public C getConsumerType();

  public JmsAckMode getAckMode();
}
